
<?php $__env->startSection('admin_title'); ?>
    <?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="header pb-8 pt-5 pt-md-8">
        <div class="container-fluid">
            <div class="header-body">

                <h1 class="mb-3 mt--3"><?php echo e(__('Welcome!')); ?>, <?php echo e(auth()->user()->name); ?></h1>
                <?php if(count($tasks) > 0): ?>
                    <?php echo $__env->make('dashboard::tasks', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <?php $__currentLoopData = config('global.modulesWithDashboardInfo'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $moduleWithDashboardInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make($moduleWithDashboardInfo . '::dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(auth()->user()->hasRole('staff') || auth()->user()->hasRole('owner')): ?>
                    <div class="d-flex">
                        <div class="px-5">
                            <canvas id="myChart1" class="chart" height="370" width="400"></canvas>
                        </div>
                        <div class="px-5">
                            <canvas id="myChart2" class="chart" height="370" width="400"></canvas>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="container-fluid mt--6">
        <?php echo $__env->yieldContent('dashboard_content'); ?>
        <?php echo $__env->yieldContent('dashboard_content2'); ?>
        <?php echo $__env->yieldContent('dashboard_content3'); ?>
        <?php echo $__env->yieldContent('dashboard_content4'); ?>
    </div>
<?php $__env->stopSection(); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        axios.get('/api/wpbox/dataForGraphs')
            .then(function(response) {
                var data = response.data;

                // Verificar si los datos son de 'consultants' o 'contacts'
                if (data.consultants) {
                    // Datos para la gráfica de consultores
                    var ctx1 = document.getElementById('myChart1').getContext('2d');
                    var myChart1 = new Chart(ctx1, {
                        type: 'bar',
                        data: {
                            labels: data.consultants,
                            datasets: [{
                                label: 'Conversaciones en el mes',
                                data: data.conversations,
                                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });

                    // Datos para la segunda gráfica de consultores
                    var ctx2 = document.getElementById('myChart2').getContext('2d');
                    var myChart2 = new Chart(ctx2, {
                        type: 'bar',
                        data: {
                            labels: data.consultants,
                            datasets: [{
                                label: 'Duracion promedio de conversaciones',
                                data: data.duration,
                                backgroundColor: 'rgba(153, 102, 255, 0.2)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });
                } else {
                    // Datos para la gráfica de contactos
                    var ctx1 = document.getElementById('myChart1').getContext('2d');
                    var myChart1 = new Chart(ctx1, {
                        type: 'bar',
                        data: {
                            labels: data.contacts,
                            datasets: [{
                                label: 'Conversaciones en el mes',
                                data: data.conversations,
                                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });

                    // Datos para la segunda gráfica de contactos
                    var ctx2 = document.getElementById('myChart2').getContext('2d');
                    var myChart2 = new Chart(ctx2, {
                        type: 'bar',
                        data: {
                            labels: data.contacts,
                            datasets: [{
                                label: 'Duracion promedio de conversaciones',
                                data: data.duration,
                                backgroundColor: 'rgba(153, 102, 255, 0.2)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });
                }
            })
            .catch(function(error) {
                console.error(error);
            });
    });
</script>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\microzip\Documents\Job Eleazar Valenzuela Ortiz\Desarrollos NG\Proyectos\facturador-jmas\Sichat\modules\Dashboard\Providers/../Resources/views/index.blade.php ENDPATH**/ ?>