<?php $__env->startSection('thead'); ?>
    <div class="row mb-4">
        <!-- Botón para descargar solicitudes no resueltas -->
        <div class="col-md-4 text-center">
            <a href="<?php echo e(route('solicitudes.reporte')); ?>" class="btn btn-warning">
                <i class="fas fa-download"></i> <?php echo e(__('Descargar no resueltas')); ?>

            </a>
        </div>
        <div class="col-md-4 text-center">
            <a href="<?php echo e(route('solicitudes.solicitudesPendientes')); ?>" class="btn btn-success">
                <i class="fas fa-download"></i> <?php echo e(__('Descargar pendientes')); ?>

            </a>
        </div>
        <div class="col-md-4 text-center">
            <a href="<?php echo e(route('solicitudes.solicitudesExcel')); ?>" class="btn btn-primary">
                <i class="fas fa-file-excel"></i> <?php echo e(__('Descargar todos en excel')); ?>

            </a>
        </div>
    </div>

    <!-- Contenedor del buscador -->
    <div class="row mb-4">
        <div class="col-md-12">
            <form method="GET" action="<?php echo e(route('solicitudes.index')); ?>" class="d-flex flex-wrap gap-2">
                <input type="text" name="folio" class="form-control" placeholder="Folio"
                    value="<?php echo e(request('folio')); ?>">
                <input type="text" name="tipo_solicitud" class="form-control" placeholder="Tipo de reporte"
                    value="<?php echo e(request('tipo_solicitud')); ?>">
                <input type="text" name="nombre_contacto" class="form-control" placeholder="Nombre del contacto"
                    value="<?php echo e(request('nombre_contacto')); ?>">
                <input type="text" name="ubicacion" class="form-control" placeholder="Ubicación"
                    value="<?php echo e(request('ubicacion')); ?>">
                Fecha de inicio
                <input type="date" name="fecha_inicio" class="form-control" placeholder="Fecha inicio"
                    value="<?php echo e(request('fecha_inicio')); ?>">
                Fecha de fin
                <input type="date" name="fecha_fin" class="form-control" placeholder="Fecha fin"
                    value="<?php echo e(request('fecha_fin')); ?>">

                <select name="estatus" class="form-select">
                    <option value=""><?php echo e(__('Todos los estatus')); ?></option>
                    <option value="PENDIENTE" <?php echo e(request('estatus') == 'PENDIENTE' ? 'selected' : ''); ?>>Pendiente</option>
                    <option value="PROCESADO" <?php echo e(request('estatus') == 'PROCESADO' ? 'selected' : ''); ?>>Procesado</option>
                    <option value="NO_SE_RESOLVIO" <?php echo e(request('estatus') == 'NO_SE_RESOLVIO ' ? 'selected' : ''); ?>>No se
                        resolvio</option>
                    <option value="RESUELTO" <?php echo e(request('estatus') == 'RESUELTO' ? 'selected' : ''); ?>>Resuelto</option>
                    <option value="CANCELADO" <?php echo e(request('estatus') == 'CANCELADO' ? 'selected' : ''); ?>>Cancelado</option>
                </select>

                <select name="estatusOpciones" class="form-select">
                    <option value=""><?php echo e(__('Todas las opciones de estatus')); ?></option>
                    <option value="1" <?php echo e(request('estatusOpciones') == '1' ? 'selected' : ''); ?>>Creado</option>
                    <option value="2" <?php echo e(request('estatusOpciones') == '2' ? 'selected' : ''); ?>>Capturado</option>
                    <option value="3" <?php echo e(request('estatusOpciones') == '3' ? 'selected' : ''); ?>>En ejecución</option>
                    <option value="4" <?php echo e(request('estatusOpciones') == '4' ? 'selected' : ''); ?>>Terminado</option>
                    <option value="5" <?php echo e(request('estatusOpciones') == '5' ? 'selected' : ''); ?>>Crítico</option>
                </select>
                <select name="per_page" class="form-select" onchange="this.form.submit()">
                    <option value="10" <?php echo e(request('per_page') == 10 ? 'selected' : ''); ?>>10 por página</option>
                    <option value="20" <?php echo e(request('per_page') == 20 ? 'selected' : ''); ?>>20 por página</option>
                    <option value="50" <?php echo e(request('per_page') == 50 ? 'selected' : ''); ?>>50 por página</option>
                    <option value="100" <?php echo e(request('per_page') == 100 ? 'selected' : ''); ?>>100 por página</option>
                </select>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-search"></i> <?php echo e(__('Buscar')); ?>

                </button>
                <?php if(request()->anyFilled([
                        'folio',
                        'tipo_reporte',
                        'nombre_contacto',
                        'ubicacion',
                        'estatus',
                        'fecha_inicio',
                        'fecha_fin',
                    ])): ?>
                    <a href="<?php echo e(route('solicitudes.index')); ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-times"></i> <?php echo e(__('Limpiar')); ?>

                    </a>
                <?php endif; ?>
            </form>
        </div>
    </div>
    <!-- Botón para guardar cambios -->
    

    <!-- Encabezados de la tabla -->
    <table class="table table-hover table-striped align-middle">
        <thead class="table-dark">
            <tr>
                <th><?php echo e(__('Folio')); ?></th>
                <th><?php echo e(__('Tipo de solicitud')); ?></th>
                <th><?php echo e(__('Estatus')); ?></th>
                <th><?php echo e(__('Estatus opciones')); ?></th>
                <th><?php echo e(__('Acciones')); ?></th>
                <th><?php echo e(__('Contacto')); ?></th>
                <th><?php echo e(__('Descripción')); ?></th>
                <th><?php echo e(__('Ubicación')); ?></th>
                <th><?php echo e(__('Creada el')); ?></th>
            </tr>
        </thead>
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('tbody'); ?>
        <tbody>
            <?php if($setup['items'][0][0] && $setup['items'][0][0]->id == 0): ?>
                <tr>
                    <td>
                        No se encontraron registros
                    </td>
                </tr>
            <?php else: ?>
                <?php $__empty_1 = true; $__currentLoopData = $setup['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><span class="badge bg-info"><?php echo e($item->folio); ?></span></td>
                        <td><?php echo e($item->tipo_solicitud); ?></td>
                        <td>
                            <span
                                class="badge
                        <?php if($item->estatus === 'PENDIENTE'): ?> bg-warning
                        <?php elseif($item->estatus === 'COMPLETADO'): ?> bg-success
                        <?php else: ?> bg-secondary <?php endif; ?>">
                                <?php echo e($item->estatus); ?>

                            </span>
                        </td>

                        <td>
                            <?php
                                $estatus = [
                                    1 => 'Creado',
                                    2 => 'Capturado',
                                    3 => 'En ejecución',
                                    4 => 'Terminado',
                                    5 => 'Crítico',
                                ];
                            ?>
                            <select class="form-select cambio-select" data-id="<?php echo e($item->id); ?>">
                                <?php $__currentLoopData = $estatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($key >= $item->estatusOpciones): ?>
                                        <option value="<?php echo e($key); ?>"
                                            <?php echo e($item->estatusOpciones == $key ? 'selected' : ''); ?>><?php echo e($label); ?>

                                        </option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td>
                            <?php if($item->estatus == 'PENDIENTE'): ?>
                                <a href="<?php echo e(route('solicitudes.sendStatus', ['id' => $item->id])); ?>"
                                    class="btn btn-success btn-sm" title="<?php echo e(__('Marcar como completado')); ?>">
                                    <i class="ni ni-check-bold"></i>
                                </a>
                            <?php endif; ?>
                            <?php if($item->estatus == 'NO_SE_RESOLVIO'): ?>
                                <a href="<?php echo e(route('solicitudes.sendStatus', ['id' => $item->id])); ?>"
                                    class="btn btn-success btn-sm" title="<?php echo e(__('Marcar como resuelto')); ?>">
                                    <i class="ni ni-check-bold"></i>
                                </a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('solicitudes.imprimirSolicitud', ['id' => $item->id])); ?>"
                                class="btn btn-success btn-sm" title="<?php echo e(__('Imprimir reporte')); ?>">
                                <i class="ni ni-single-copy-04"></i>
                            </a>
                            <?php if($item->estatus != 'RESUELTO' && $item->estatus != 'CANCELADO'): ?>
                                <a href="<?php echo e(route('solicitudes.cancelarSolicitud', ['id' => $item->id])); ?>"
                                    class="btn btn-danger btn-sm" title="<?php echo e(__('Cancelar reporte')); ?>">
                                    <i class="ni ni-fat-remove"></i> <?php echo e(__('Cancelar')); ?>

                                </a>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('chat.index', ['id_contacto' => $item->id_contacto])); ?>" class="badge badge-primary">
                                <i class="fas fa-user"></i> <?php echo e($item->nombre_contacto); ?>

                            </a>
                        </td>
                        <td><?php echo e($item->descripcion_solicitud ?? __('Sin descripción')); ?></td>
                        <td><?php echo e($item->ubicacion); ?></td>
                        <td><?php echo e($item->created_at->format('d/m/Y')); ?></td>

                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted"><?php echo e(__('No se encontraron solicitudes.')); ?></td>
                    </tr>
                <?php endif; ?>
            <?php endif; ?>
        </tbody>
    </table>


    <script>
        document.querySelectorAll('.cambio-select').forEach(select => {
            select.addEventListener('change', function() {
                let id = this.dataset.id;
                let opcion = this.value;

                fetch("<?php echo e(route('solicitudes.guardarCambios')); ?>", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({
                        cambios: [{ id: id, opcion: opcion }]
                    })
                }).then(response => response.json())
                .then(data => {
                    console.log('Cambio guardado:', data);
                }).catch(error => console.error('Error:', error));
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('general.index', $setup, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\microzip\Documents\Job Eleazar Valenzuela Ortiz\Desarrollos NG\Proyectos\facturador-jmas\Sichat\modules\Solicitudes\Providers/../Resources/views/index.blade.php ENDPATH**/ ?>