<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Folio <?php echo e($reporte->folio); ?></title>
    <style>
        @page {
            size: A4;
            margin: 20mm;
        }

        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            width: 100%;
        }

        .container {
            width: 100%;
            padding: 10px;
        }

        .header,
        .footer {
            text-align: center;
            font-weight: bold;
        }

        .section {
            margin-bottom: 20px;
        }

        .section-title {
            background-color: #ddd;
            padding: 5px;
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td,
        th {
            padding: 9px;
            border: 1px solid #ccc;
            font-size: 12px;
            height: 40px;
        }

        .highlight {
            font-weight: bold;
        }

        .empty-space {
            height: 50px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <p>JUNTA MUNICIPAL DE AGUA Y SANEAMIENTO DE CUAUHTÉMOC</p>
            <h2>Folio <?php echo e($reporte->folio); ?></h2>
        </div>

        <div class="section">
            <table>
                <tr>
                    <?php
                        $estatus = [
                            1 => 'Creado',
                            2 => 'Capturado',
                            3 => 'En ejecución',
                            4 => 'Terminado',
                            5 => 'Critico',
                        ];
                        $reporte->estatusOpciones = $estatus[$reporte->estatusOpciones];
                    ?>
                    <td><span class="highlight">Estado:</span> <?php echo e($reporte->estatusOpciones); ?></td>
                    <td><span class="highlight">Departamento:</span> JMAS CUAUHTÉMOC</td>
                </tr>
                <tr>
                    <td><span class="highlight">Prioridad:</span>
                        <div class="empty-space"></div>
                    </td>
                    <td><span class="highlight">Asignado a:</span>
                        <div class="empty-space"></div>
                    </td>
                </tr>
                <tr>
                    <td><span class="highlight">Creado en:</span> <?php echo e($reporte->created_at); ?></td>
                    <td><span class="highlight">Fuente:</span> Whatsapp</td>
                </tr>
                <tr>
                    <td colspan="2"><span class="highlight">Nombre o numero de servicio:</span>
                        <?php echo e($reporte->nombre_o_servicio); ?></td>
                </tr>
            </table>
        </div>
        <div style="margin-top:10px;">
            Ubicacion: <?php echo e($reporte->ubicacion); ?>

        </div>
        <div style="margin-top:10px;">
            Referencia: <?php echo e($reporte->referencia); ?>

        </div>
        <div style="margin-top:10px;">
            Url maps: <?php echo e($reporte->url_maps); ?>

        </div>
        <div class="section">
            <div class="section-title">Detalle del reporte</div>
            <table>
                <tr>
                    <td><span class="highlight">Colonia:</span> <?php echo e($name); ?></td>
                    <td><span class="highlight">Tipo de Suelo:</span>
                        <?php echo e($reporte->tipo_suelo ?? ''); ?>

                    </td>
                    </td>
                </tr>
                <tr>
                    <td colspan="2"><span class="highlight">Miembros de la cuadrilla asignados:</span>
                    </td>
                </tr>
            </table>
        </div>

        <div class="section">
            <div class="section-title">Reporte</div>
            <table>
                <tr>
                    <td><span class="highlight">Reporta Lecturista:</span><?php echo e($contact_name); ?></td>
                    <td><span class="highlight">Teléfono:</span> <?php echo e($reporte->celular); ?></td>
                </tr>
                <tr>
                    <?php if($reporte->tipo_suelo): ?>
                        <td><span class="highlight">Folio:</span> <?php echo e($reporte->folio); ?></td>
                        <td><span class="highlight">Tipo de suelo:</span> <?php echo e($reporte->tipo_suelo); ?></td>
                    <?php else: ?>
                        <td colspan="2"><span class="highlight">Folio:</span> <?php echo e($reporte->folio); ?></td>
                    <?php endif; ?>
                </tr>
                <tr>
                    <td colspan="2"><span class="highlight">Tipo de reporte: </span><?php echo e($reporte->tipo_reporte); ?>

                    </td>
                </tr>
            </table>
        </div>

        <div class="section">
            <div class="section-title">Actualizaciones</div>
        </div>

    </div>
</body>

</html>
<?php /**PATH C:\Users\microzip\Documents\Job Eleazar Valenzuela Ortiz\Desarrollos NG\Proyectos\facturador-jmas\Sichat\resources\views/reportes/reporte.blade.php ENDPATH**/ ?>