
<?php $__env->startSection('contenttop'); ?>
<div class="card-body">
    <div class="row">
        <div class="col-12">

            <!-- Groups modal -->
            <div class="modal fade" id="move-to-group-modal" tabindex="-1" role="dialog" aria-labelledby="moveToGroupModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="moveToGroupModalLabel"><?php echo e(__('Add to group')); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <?php $__currentLoopData = $setup['groups']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="group" id="group-<?php echo e($group->id); ?>" value="<?php echo e($group->id); ?>">
                                    <label class="form-check-label" for="group-<?php echo e($group->id); ?>">
                                        <?php echo e($group->name); ?>

                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="button" class="btn btn-primary" id="move-to-group-confirm"><?php echo e(__('Add')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="remove-from-group-modal" tabindex="-1" role="dialog" aria-labelledby="removeFromGroupModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="removeFromGroupModalLabel"><?php echo e(__('Remove from group')); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <?php $__currentLoopData = $setup['groups']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="groupremove" id="group-<?php echo e($group->id); ?>" value="<?php echo e($group->id); ?>">
                                    <label class="form-check-label" for="group-<?php echo e($group->id); ?>">
                                        <?php echo e($group->name); ?>

                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="button" class="btn btn-primary" id="remove-from-group-confirm"><?php echo e(__('Remove')); ?></button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bulk action button, initially hidden -->
            <div class="btn-group" id="bulk-action-button" style="display: none;">
                <button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="ni ni-archive-2"></i>
                    <?php echo e(__('Bulk action')); ?>

                </button>
                <div class="dropdown-menu">
                    <a class="dropdown-item" href="#" id="move-to-group"><?php echo e(__('Add to group')); ?></a>
                    <a class="dropdown-item" href="#" id="remove-from-group"><?php echo e(__('Remove from group')); ?></a>
                    <a class="dropdown-item" href="#" id="delete-selected"><?php echo e(__('Delete selected')); ?></a>
                </div>
            </div>
            <div class="col-12 mt-3">
                <span id="selected-count"></span>
            </div>

        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('thead'); ?>
    <th><input type="checkbox" id="select-all"></th>
    <th><?php echo e(__('Name')); ?></th>
    <th><?php echo e(__('Phone')); ?></th>
    <th><?php echo e(__('Create at')); ?></th>
    <th><?php echo e(__('Groups')); ?></th>
    <th><?php echo e(__('crud.actions')); ?></th>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('tbody'); ?>
    <?php $__currentLoopData = $setup['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><input type="checkbox" class="select-item" value="<?php echo e($item->id); ?>"></td>
            <td><?php echo e($item->name); ?></td>
            <td><?php echo e($item->phone); ?></td>
            <td><?php echo e($item->created_at->format('Y-m-d')); ?></td>
            <td>
                <?php $__currentLoopData = $item->groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="/contacts/contacts?group=<?php echo e($group->id); ?>" class="badge badge-primary"><?php echo e($group->name); ?></a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </td>
            <td>
                <!-- CHAT -->
                <a href="<?php echo e(route('campaigns.create',['contact_id'=>$item->id])); ?>" class="btn btn-outline-success btn-sm">
                    <span class="btn-inner--icon"><i class="ni ni-chat-round"></i></span>
                    <span class="btn-inner--text"><?php echo e(__('Send template')); ?></span>
                </a>

                <!-- EDIT -->
                <a href="<?php echo e(route('contacts.edit',['contact'=>$item->id])); ?>" class="btn btn-primary btn-sm">
                    <i class="ni ni-ruler-pencil"></i>
                </a>

                <!-- DELETE -->
                <a href="<?php echo e(route('contacts.delete',['contact'=>$item->id])); ?>" class="btn btn-danger btn-sm">
                    <i class="ni ni ni-fat-remove"></i>
                </a>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <?php echo $__env->make('contacts::contacts.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('general.index', $setup, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\microzip\Documents\Job Eleazar Valenzuela Ortiz\Desarrollos NG\Proyectos\facturador-jmas\Sichat\modules\Contacts\Providers/../Resources/views/contacts/index.blade.php ENDPATH**/ ?>