<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Encuestas</title>
    <style>
        body {
            font-family: 'Courier New', Courier, monospace;
            margin: 0;
            padding: 20px;
            background-color: #fff;
            color: #000;
        }

        h1,
        h2 {
            color: #000;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }

        p {
            font-size: 14px;
            color: #000;
        }

        ul {
            list-style-type: none;
            padding: 0;
        }

        ul li {
            background-color: #f1f1f1;
            margin: 5px 0;
            padding: 8px;
            border-radius: 3px;
            font-family: 'Courier New', Courier, monospace;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #fff;
        }

        table,
        th,
        td {
            border: 1px solid #000;
        }

        th,
        td {
            padding: 10px;
            text-align: left;
            font-family: 'Courier New', Courier, monospace;
            color: #000;
        }

        td {
            font-size: 12px;
        }

        th {
            background-color: #000;
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f1f1f1;
        }

        tr:hover {
            background-color: #e1e1e1;
        }

        .summary {
            margin: 20px 0;
        }

        .summary p {
            margin: 0;
        }
    </style>
</head>

<body>
    <h1>Reporte de Encuestas</h1>
    <div class="summary">
        <p>Total de Encuestas: {{ count($encuestas) }}</p>
        <p>Rango de fechas: {{ $fechaInicio }} - {{ $fechaFin }}</p>
        @if($consultor)
            <p>Consultor: {{$consultor->name}}</p>
        @endif
    </div>

    <h2>Conteo de Respuestas</h2>
    <ul>
        @foreach ($radioResponsesCount as $question => $responses)
            <li><strong>{{ $question }}</strong></li>
            <ul>
                @foreach ($responses as $response => $count)
                    <li>{{ $response }}: {{ $count }} veces</li>
                @endforeach
            </ul>
        @endforeach
    </ul>

    <h2>Respuestas Detalladas</h2>
    <table>
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Respuesta</th>
                <th>Fecha</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($encuestas as $encuesta)
                <tr>
                    <td>{{ $encuesta->contacto->name }}</td>
                    <td>
                        @php
                            $respuestasFormateadas = \Modules\Reports\Http\Controllers\HelpersReportesController::formatSurveyResponse($encuesta->respuesta_encuesta);
                        @endphp
                        {{ $respuestasFormateadas }}
                    </td>
                    <td>{{ $encuesta->created_at }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
