<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Encuestas</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #fff;
        }

        table,
        th,
        td {
            border: 1px solid #000;
        }

        th,
        td {
            padding: 10px;
            text-align: left;
            font-family: 'Courier New', Courier, monospace;
            color: #000;
        }

        td {
            font-size: 12px;
        }

        th {
            background-color: #000;
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f1f1f1;
        }

        tr:hover {
            background-color: #e1e1e1;
        }

        .summary {
            margin: 20px 0;
        }

        .summary p {
            margin: 0;
        }
    </style>
</head>

<body>
    <h1>Reporte de Encuestas</h1>
    <div class="summary">
        <p>Total de Encuestas: {{ count($encuestas) }}</p>
    </div>

    <h2>Respuestas</h2>
    <table>
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Fecha</th>
                <th>Respuestas</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($encuestas as $encuesta)
                <tr>
                    <td>{{ $encuesta->contacto->name }}</td>
                    <td>{{ $encuesta->contacto->created_at }}</td>
                    <td>
                        <ul>
                            @php
                                $respuestas = json_decode($encuesta->respuesta_encuesta, true);
                                $respuestasFormateadas = \Modules\Reports\Http\Controllers\HelpersReportesController::formatSurveyResponse(
                                    $encuesta->respuesta_encuesta,
                                );
                            @endphp
                            <li>{{ $respuestasFormateadas }}</li>
                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
