<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Campaña</title>
    <style>
        body {
            font-family: 'Courier New', Courier, monospace;
            margin: 0;
            padding: 20px;
            background-color: #fff;
            color: #000;
        }

        h1,
        h2 {
            color: #000;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }

        p {
            font-size: 14px;
            color: #000;
        }

        ul {
            list-style-type: none;
            padding: 0;
        }

        ul li {
            background-color: #f1f1f1;
            margin: 5px 0;
            padding: 8px;
            border-radius: 3px;
            font-family: 'Courier New', Courier, monospace;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #fff;
        }

        table,
        th,
        td {
            border: 1px solid #000;
        }

        th,
        td {
            padding: 10px;
            text-align: left;
            font-family: 'Courier New', Courier, monospace;
            color: #000;
        }

        td {
            font-size: 12px;
        }

        th {
            background-color: #000;
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f1f1f1;
        }

        tr:hover {
            background-color: #e1e1e1;
        }

        .summary {
            margin: 20px 0;
        }

        .summary p {
            margin: 0;
        }
    </style>
</head>

<body>
    <h1>Reporte de la Campaña: {{ $campaign->name }}</h1>
    <div class="summary">
        <p>Total de Mensajes: {{ $totalMessages }}</p>
        @if (array_sum($radioResponsesCount) > 0)
            <p>Total de Respuestas: {{ array_sum($radioResponsesCount) }}</p>
        @endif
    </div>
    @if (array_sum($radioResponsesCount) > 0)
        <h2>Conteo de Respuestas</h2>
        <ul>
            @foreach ($radioResponsesCount as $response => $count)
                <li>{{ $response }}: {{ $count }} veces</li>
            @endforeach
        </ul>
    @endif

    <h2>Mensajes</h2>
    <table>
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Teléfono</th>
                <th>País</th>
                <th>Estado</th>
                <th>Enviado a las</th>
                @if (array_sum($radioResponsesCount) > 0)
                    <th>Respuesta</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @foreach ($messages as $message)
                <tr>
                    <td>{{ $message['name'] }}</td>
                    <td>{{ $message['phone'] }}</td>
                    <td>{{ $message['country'] }}</td>
                    <td>{{ $message['status'] }}</td>
                    <td>{{ $message['sent_at'] }}</td>
                    @if (array_sum($radioResponsesCount) > 0)
                        <td>{{ $message['respuesta'] }}</td>
                    @endif
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
