<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitudes No Resueltas</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 90%;
            margin: 20px auto;
        }
        .solicitud {
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .solicitud h3 {
            margin: 0 0 10px;
            text-align: center;
            color: #333;
        }
        .solicitud p {
            margin: 10px 0;
            color: #555;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Solicitudes No Resueltas</h1>
        @forelse ($solicitudes as $solicitud)
            <div class="solicitud">
                <h3>Folio de solicitud {{ $solicitud->folio }}</h3>
                <p><strong>Tipo de Solicitud:</strong> {{ $solicitud->tipo_solicitud }}</p>
                <p><strong>Celular:</strong> {{ $solicitud->celular }}</p>
                <p><strong>Nombre de la Persona:</strong> {{ $solicitud->nombre_persona }}</p>
                <p><strong>Descripción:</strong> {{ $solicitud->descripcion_solicitud }}</p>
                <p><strong>Ubicación:</strong> {{ $solicitud->ubicacion }}</p>
                <p><small>Fecha de Creación: {{ $solicitud->created_at->format('d/m/Y H:i') }}</small></p>
            </div>
        @empty
            <p>No hay solicitudes para mostrar.</p>
        @endforelse
    </div>
</body>
</html>
