<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Folio {{ $solicitud->folio }}</title>
    <style>
        @page {
            size: A4;
            margin: 20mm;
        }

        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            width: 100%;
        }

        .container {
            width: 100%;
            padding: 20px;
        }

        .header,
        .footer {
            text-align: center;
            font-weight: bold;
        }

        .section {
            margin-bottom: 20px;
        }

        .section-title {
            background-color: #ddd;
            padding: 5px;
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td,
        th {
            padding: 9px;
            border: 1px solid #ccc;
            font-size: 12px;
            height: 40px;
        }

        .highlight {
            font-weight: bold;
        }

        .empty-space {
            height: 50px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <p>JUNTA MUNICIPAL DE AGUA Y SANEAMIENTO DE CUAUHTÉMOC</p>
            <h2>Folio {{ $solicitud->folio }}</h2>
        </div>

        <div class="section">
            <table>
                <tr>
                    @php
                        $estatus = [
                            1 => 'Creado',
                            2 => 'Capturado',
                            3 => 'En ejecución',
                            4 => 'Terminado',
                            5 => 'Critico',
                        ];
                        $solicitud->estatusOpciones = $estatus[$solicitud->estatusOpciones]
                    @endphp
                    <td><span class="highlight">Estado:</span> {{ $solicitud->estatusOpciones }}</td>
                    <td><span class="highlight">Departamento:</span> JMAS CUAUHTÉMOC</td>
                </tr>
                <tr>
                    <td><span class="highlight">Prioridad:</span> <div class="empty-space"></div></td>
                    <td><span class="highlight">Asignado a:</span> <div class="empty-space"></div></td>
                </tr>
                <tr>
                    <td><span class="highlight">Creado en:</span> {{ $solicitud->created_at }}</td>
                    <td><span class="highlight">Fuente:</span> Whatsapp</td>
                </tr>
                <tr>
                    <td colspan="2"><span class="highlight">Nombre o numero de servicio:</span> {{ $solicitud->nombre_persona }}</td>
                </tr>
            </table>
        </div>
        <div style="margin-top:10px;">
            Ubicacion: {{ $solicitud->ubicacion }}
        </div>
        <div style="margin-top:10px;">
            Referencia: {{ $solicitud->referencia }}
        </div>
        <div style="margin-top:10px; margin-bottom: 10px;">
            Url maps: {{ $solicitud->url_maps }}
        </div>
        <div class="section">
            <div class="section-title">Detalle del solicitud</div>
            <table>
                <tr>
                    <td><span class="highlight">Colonia:</span> {{ $name }}</td>
                    <td><span class="highlight">Tipo de Suelo:</span> <div class="empty-space"></div></td>
                </tr>
                <tr>
                    <td colspan="2"><span class="highlight">Miembros de la cuadrilla asignados:</span> <div class="empty-space"></div></td>
                </tr>
            </table>
        </div>

        <div class="section">
            <div class="section-title">Solicitud</div>
            <table>
                <tr>
                    <td><span class="highlight">Reporta Lecturista:</span>{{ $contact_name }}</td>
                    <td><span class="highlight">Teléfono:</span> {{ $solicitud->celular }}</td>
                </tr>
                <tr>
                    <td colspan="2"><span class="highlight">Folio:</span> {{ $solicitud->folio }}</td>
                </tr>
            </table>
        </div>

        <div class="section">
            <div class="section-title">Actualizaciones</div>
        </div>

    </div>
</body>

</html>
