<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reportes No Resueltos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 90%;
            margin: 20px auto;
        }
        .reporte {
            background-color: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .reporte h3 {
            margin: 0 0 10px;
            text-align: center;
            color: #333;
        }
        .reporte p {
            margin: 10px 0;
            color: #555;
        }
        .reporte img {
            display: block;
            max-width: 100%;
            height: auto;
            border-radius: 5px;
            margin: 20px auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Reportes No Resueltos</h1>
        @forelse ($reportes as $reporte)
            @if ($reporte->estatus !== 'resuelto')
                <div class="reporte">
                    <h3>Folio de reporte {{ $reporte->folio }}</h3>
                    <p><strong>Tipo de Reporte:</strong> {{ $reporte->tipo_reporte }}</p>
                    <p><strong>Celular:</strong> {{ $reporte->celular }}</p>
                    <p><strong>Nombre o Servicio:</strong> {{ $reporte->nombre_o_servicio }}</p>
                    <p><strong>Descripción:</strong> {{ $reporte->descripcion_reporte }}</p>
                    <p><strong>Ubicación:</strong> {{ $reporte->ubicacion }}</p>
                    @if (!empty($reporte->foto_reporte))
                        <img src="{{ $reporte->foto_reporte }}" alt="Foto del Reporte" width="150" height="150">
                    @endif
                    @if (!empty($reporte->foto_context_lugar))
                        <img src="{{ $reporte->foto_context_lugar }}" alt="Foto del Contexto del Lugar" width="150" height="150">
                    @endif
                    <p><small>Fecha de Creación: {{ $reporte->created_at->format('d/m/Y H:i') }}</small></p>
                </div>
            @endif
        @empty
            <p>No hay reportes para mostrar.</p>
        @endforelse
    </div>
</body>
</html>
