<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Reporte de Conversaciones</title>
    <style>
        body {
            font-family: 'Courier New', Courier, monospace;
            margin: 20px;
            background-color: #fff;
            color: #000;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #fff;
        }
        th, td {
            padding: 8px;
            border: 1px solid #000;
            text-align: left;
        }
        th {
            background-color: #000;
            color: #fff;
        }
        td {
            font-size: 13px;
        }
        h3 {
            margin-bottom: 20px;
            color: #000;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }
    </style>
</head>
<body>
    <h3>Conversación del consultor: {{ $consultor->name }} </h3>
    <h3>Contacto: {{ $contacto->name }}</h3>
    <table>
        <thead>
            <tr>
                <th>Fecha y Hora</th>
                <th>Mensaje contacto</th>
                <th>Mensaje consultor</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($conversaciones as $conversacion)
                @foreach ($conversacion->messages as $mensaje)
                    <tr>
                        <td>{{ $mensaje->created_at }}</td>
                        @if ($mensaje->is_message_by_contact)
                            <td>{{ $mensaje->value }}</td>
                            <td></td>
                        @else
                            <td></td>
                            <td>{{ $mensaje->value }}</td>
                        @endif
                    </tr>
                @endforeach
            @endforeach
        </tbody>
    </table>
</body>
</html>
