@extends('general.index', $setup)
@section('cardbody')
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <form action="{{ $setup['action'] }}" method="POST" enctype="multipart/form-data">
        @csrf
        @isset($setup['isupdate'])
            @method('PUT')
        @endisset
        @isset($setup['inrow'])
            <div class="row">
            @endisset
            @include('partials.fields', ['fiedls' => $fields])
            @isset($setup['inrow'])
            </div>
        @endisset
        @if (isset($setup['isupdate']))
            <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
        @else
            <button type="submit" class="btn btn-primary">{{ __('Insert') }}</button>
        @endif
    </form>
@endsection
