<?php

namespace Modules\Wpbox\Traits;

use App\Models\Company;
use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\Reporte;
use App\Models\RespuestaEncuesta;
use App\Models\Solicitud;
use Modules\Wpbox\Events\Chatlistchange;
use Modules\Wpbox\Events\ContactReplies;
use Modules\Wpbox\Http\Controllers\CampaignsController;
use Modules\Wpbox\Http\Controllers\ChatController;
use Modules\Wpbox\Http\Controllers\HelpersChatController;
use Modules\Wpbox\Http\Controllers\MensajesInformes;
use Modules\Wpbox\Http\Controllers\Registro;
use Modules\Wpbox\Http\Controllers\Reportes\Alcantarilla;
use Modules\Wpbox\Http\Controllers\Reportes\Baches;
use Modules\Wpbox\Http\Controllers\Reportes\Drenaje;
use Modules\Wpbox\Http\Controllers\Reportes\Falta_agua;
use Modules\Wpbox\Http\Controllers\Reportes\Fugas;
use Modules\Wpbox\Http\Controllers\Reportes\OtroTipo;
use Modules\Wpbox\Http\Controllers\Solicitudes;
use Modules\Wpbox\Http\Controllers\Solicitudes\Llave_Paso;
use Modules\Wpbox\Http\Controllers\Solicitudes\Pipa_Agua;
use Modules\Wpbox\Http\Controllers\Solicitudes\Reconexiones;
use Modules\Wpbox\Http\Controllers\Solicitudes\Vactor_Fosa_Septica;
use Modules\Wpbox\Http\Controllers\VerificarHorariosController;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;
use Laravel\Sanctum\PersonalAccessToken;
use Illuminate\Http\Request;
use Modules\Contacts\Models\Contact;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Modules\Wpbox\Models\Campaign;
use Modules\Wpbox\Models\Template;

trait Whatsapp
{

    public static $facebookAPI = 'https://graph.facebook.com/v21.0/';

    private function getToken(Company $company = null)
    {
        if ($company == null) {
            $company = $this->getCompany();
        }
        return $company->getConfig('whatsapp_permanent_access_token', '');
    }

    private function getPhoneID(Company $company = null)
    {
        if ($company == null) {
            $company = $this->getCompany();
        }
        return $company->getConfig('whatsapp_phone_number_id', '');
    }

    private function getAccountID(Company $company = null)
    {
        if ($company == null) {
            $company = $this->getCompany();
        }
        return $company->getConfig('whatsapp_business_account_id', '');
    }



    private function sendCampaignMessageToWhatsApp(Message $message)
    {

        //We need data per company
        $company = null;
        try {
            $company = $message->campaign->company;
            $message->contact->phone;
        } catch (\Throwable $th) {
            $message->error = "The company or contact is not found";
            $message->status = 1;
            $message->update();
        }

        if ($company) {
            $url = self::$facebookAPI . $this->getPhoneID($company) . '/messages';
            $accessToken = $this->getToken($company);
            try {
                $components = [
                    'messaging_product' => 'whatsapp',
                    'to' => $message->contact->phone, // Add recipient information
                    'type' => 'template',
                    'template' => [
                        "name" => $message->campaign->template->name,
                        "language" => [
                            "code" => $message->campaign->template->language
                        ],
                        "components" => json_decode($message->components)
                    ]
                ];
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $accessToken,
                    'Content-Type' => 'application/json',
                ])->post($url, $components);


                $statusCode = $response->status();
                $content = json_decode($response->body(), true);
                //dd($content);
                $message->created_at = now();
                if (isset($content['messages'])) {
                    $message->fb_message_id = $content['messages'][0]['id'];
                } else {
                    $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
                    //dd($content);
                }
                $message->status = 1;
                $message->update();
                // Handle the response as needed based on $statusCode and $content
            } catch (\Exception $e) {
                \Log::error(json_encode("======== Error ========"));
                \Log::error(json_encode($e));
                //dd($e);
                // Handle the exception
            }
        }


    }

    public function receiveMessage(Request $request, $token)
    {
        $token = PersonalAccessToken::findToken($token);

        if ($token) {

            // Token is valid
            // Proceed with the request handling

            //Find the user
            $user = User::findOrFail($token->tokenable_id);
            Auth::login($user);

            //if the user is admin
            if ($user->hasRole('admin')) {
                //Find company based on the WABAID
                $wabaid = $request->entry[0]['id'];
                $company_id = Config::where('value', $wabaid)->first()->model_id;
                if ($company_id) {
                    $company = Company::first();
                    if (!$company) {
                        return response()->json(['send' => false, 'error' => "Company not found"]);
                    }
                } else {
                    return response()->json(['send' => false, 'error' => "Company not found"]);
                }
            } else {
                //Company
                $company = $this->getCompany();
            }


            //Resend the Request to webhook
            try {
                $whatsapp_data_send_webhook = $company->getConfig('whatsapp_data_send_webhook', "");
                if (strlen($whatsapp_data_send_webhook) > 5) {
                    //Send the data to a webhook
                    Http::post($whatsapp_data_send_webhook, $request->all());
                }
            } catch (\Exception $e) {
                \Log::error('=============error==============');
                \Log::error(json_encode($e));
                //throw $th;
            }
            //Get the message object
            try {
                $value = $request->entry[0]['changes'][0]['value'];
                if (isset($value['statuses'])) {

                    //Status change -- Message update
                    $newStatus = $value['statuses'][0]['status'];
                    $messageFBID = $value['statuses'][0]['id'];
                    $message = Message::where('fb_message_id', $messageFBID)->first();
                    if ($message) {
                        if ($newStatus == "sent" && $message->status != 3) {
                            $message->status = 2;
                        } else if ($newStatus == "delivered" && $message->status != 4) {
                            $message->status = 3;
                        } else if ($newStatus == "read") {
                            $message->status = 4;
                        } else if ($newStatus == "failed") {
                            $message->status = 5;
                            $message->error = $value['statuses'][0]['errors'][0]['message'];
                        }
                        $message->update();
                        if ($message->campaign_id != null) {
                            $campaign = Campaign::where('id', $message->campaign_id)->first();
                            if ($campaign) {
                                if ($newStatus == "sent") {
                                    $campaign->increment('sended_to', 1);
                                } else if ($newStatus == "delivered") {
                                    $campaign->increment('delivered_to', 1);
                                } else if ($newStatus == "read") {
                                    $campaign->increment('read_by', 1);
                                }
                                $campaign->update();
                            }

                        }
                    }
                } else {
                    //Message receive
                    $phone = $value['messages'][0]['from'];

                    //Check if this phone is in the blacklist
                    $blacklist = $company->getConfig('black_listed_phone_numbers', "");
                    if (strlen($blacklist) > 5) {
                        $blacklist = explode(",", $blacklist);

                        if (in_array($phone, $blacklist)) {
                            return response()->json(['send' => false, 'error' => "Blacklisted"]);
                        }
                    }
                    $type = $value['messages'][0]['type'];
                    $name = $value['contacts'][0]['profile']['name'];
                    $messageID = $value['messages'][0]['id'];

                    //Find the contact
                    $contact = Contact::where('phone', $phone)->orWhere('phone', "+" . $phone)->first();
                    if (!$contact) {
                        //Create new contact
                        $contact = Contact::create([
                            'name' => $name,
                            'phone' => $phone,
                            'avatar' => '',
                            'company_id' => 1,
                            'has_chat' => true,
                            'created_at' => now(),
                            'updated_at' => now(),
                            'last_support_reply_at' => null,
                            'last_reply_at' => now(),
                            "last_message" => "",
                            "is_last_message_by_contact" => true,
                        ]);
                    }



                    if ($type == "image") {
                        //We need to download and store the image
                        $urlLink = $this->downloadAndStoreMedia($value['messages'][0]['image']['id'], ".jpg");

                        if ($contact->proceso_realizando && $contact->responseBot()) {
                            $message = Message::create([
                                'fb_message_id' => $value['messages'][0]['id'],
                                'contact_id' => $contact->id,
                                'buttons' => '[]',
                                'header_image' => $urlLink,
                                'value' => '',
                                'is_message_by_contact' => 1,
                                'components' => '',
                                'company_id' => 1,
                            ]);
                            event(new ContactReplies(auth()->user(), $message, $contact));

                            switch ($contact->proceso_realizando) {
                                case 'REPORTE_FUGA_AGUA_FOTO':
                                    $message = Fugas::registrar_foto_terminar_solicitud($contact->id, $urlLink);
                                    break;

                                case 'REPORTE_DRENAJE_FOTO':
                                    $message = Drenaje::registrar_foto_terminar_solicitud($contact->id, $urlLink);
                                    break;

                                case 'REPORTE_ALCANTARILLA_FOTO':
                                    $message = Drenaje::registrar_foto_terminar_solicitud_Acantarilla($contact->id, $urlLink);
                                    break;


                                case 'REPORTE_BACHE_FOTO':
                                    $message = Baches::registrar_foto_bache_pedir_foto_establcimiento($contact->id, $urlLink);
                                    break;

                                case 'REPORTE_BACHE_FOTO_ESTABLECIMIENTO':
                                    $message = Baches::registrar_foto_terminar_solicitud($contact->id, $urlLink);
                                    break;
                                default:
                                    $message = '';
                                    break;
                            }
                            if ($message) {
                                event(new ContactReplies(auth()->user(), $message, $contact));
                            }

                        } else {
                            $message = $contact->sendMessage($urlLink, true, false, "IMAGE", $messageID);
                        }
                    } else if ($type == "audio") {
                        // We need to download and store the audio
                        $urlLink = $this->downloadAndStoreMedia($value['messages'][0]['audio']['id'], '.mp3');
                        $message = $contact->sendMessage($urlLink, true, false, "AUDIO", $messageID);
                    } else if ($type == "video") {
                        //We need to download and store the video
                        $urlLink = $this->downloadAndStoreMedia($value['messages'][0]['video']['id'], '.mp4');
                        $message = $contact->sendMessage($urlLink, true, false, "VIDEO", $messageID);
                    } else if ($type == "document") {
                        //We need to download and store the video
                        $urlLink = $this->downloadAndStoreMedia($value['messages'][0]['document']['id'], '.pdf');
                        $message = $contact->sendMessage($urlLink, true, false, "DOCUMENT", $messageID);
                    } else if ($type == "text") {

                        $message = $value['messages'][0]['text']['body'];
                        if ($contact->proceso_realizando && $contact->responseBot()) {
                            $messageNew = Message::create([
                                'fb_message_id' => $value['messages'][0]['id'],
                                'contact_id' => $contact->id,
                                'buttons' => '[]',
                                'value' => $message,
                                'is_message_by_contact' => 1,
                                'components' => '',
                                'company_id' => 1,
                            ]);
                            event(new ContactReplies(auth()->user(), $messageNew, $contact));
                            switch ($contact->proceso_realizando) {

                                case 'PIDIENDO_CODIGO_POSTAL':
                                    $message = Registro::guardar_cp_pedir_colonia($contact, $message);
                                    break;

                                case 'SOLICITUD_RECONEXION_REFERENCIA':
                                    $message = Reconexiones::registrar_referencia_reconexion($contact, $message);
                                    break;

                                case 'SOLICITUD_PIPA_AGUA_REFERENCIA':
                                    $message = Pipa_Agua::registrar_referencia($contact, $message);
                                    break;

                                case 'SOLICITANDO_SALDO':
                                    $message = MensajesInformes::consultarSaldo($contact->id, $message);
                                    break;

                                case 'SOLICITUD_PIPA_AGUA_DESCRIPCION':
                                    $message = Pipa_Agua::registrar_descripcion_pipa($contact->id, $message);
                                    break;

                                case 'REPORTE_BACHES_NOMBRE_COMPLETO':
                                    $message = Baches::registrar_nombre_pedir_ubicacion_baches($contact->id, $message);
                                    break;

                                case 'REPORTE_BACHES_UBICACION':
                                    $message = Baches::registrar_ubicacion_pedir_referencia($contact->id, $message);
                                    break;
                                case 'REPORTE_BACHE_REFERENCIA':
                                    $message = Baches::registrar_referencia_pedir_foto($contact->id, $message);
                                    break;

                                case 'REPORTE_BACHE_FOTO':
                                    $message = HelpersChatController::enviarMensajeRandom(
                                        $contact->id,
                                        "⚠️ *Advertencia importante sobre tu reporte* ⚠️\n\n" .
                                        "Estás realizando el reporte de baches. Para poder procesarlo correctamente, es necesario que nos envíes una fotografía detallada del bache. 📸\n\n" .
                                        "Tu colaboración es fundamental para atender este incidente de manera eficaz. ¡Gracias por tu comprensión! 🙏"
                                    );
                                    break;

                                case 'REPORTE_BACHE_FOTO_ESTABLECIMIENTO':
                                    $message = HelpersChatController::enviarMensajeRandom(
                                        $contact->id,
                                        "⚠️ *Advertencia importante sobre tu reporte* ⚠️\n\n" .
                                        "Estás realizando el reporte de baches. Para poder procesarlo correctamente, es necesario que nos envíes una fotografía detallada de algun establecimiento de conocimiento publico cerca del bache. 📸\n\n" .
                                        "Tu colaboración es fundamental para atender este incidente de manera eficaz. ¡Gracias por tu comprensión! 🙏"
                                    );
                                    break;

                                case 'SOLICITUD_PIPA_AGUA_NOMBRE_COMPLETO':
                                    $message = Pipa_Agua::registrar_nombre_completo_pipa($contact->id, $message);
                                    break;

                                case 'SOLICITUD_PIPA_AGUA_UBICACION':
                                    $message = Pipa_Agua::registrar_ubicacion_pipa($contact->id, $message);
                                    break;

                                case 'SOLICITUD_RECONEXION_NOMBRE_PERSONA':
                                    $message = Reconexiones::registrar_nombre_completo_reconexion($contact->id, $message);
                                    break;

                                case 'SOLICITUD_RECONEXION_UBICACION':
                                    $message = Reconexiones::registrar_ubicacion_reconexion($contact->id, $message);
                                    break;

                                case 'SOLICITUD_LLAVE_PASO_NOMBRE_PERSONA':
                                    $message = Llave_Paso::registrar_nombre_completo_llave_paso($contact->id, $message);
                                    break;
                                case 'SOLICITUD_LLAVE_PASO_REFERENCIA':
                                    $message = Llave_Paso::registrar_referencia_llave_paso($contact->id, $message);
                                    break;

                                case 'SOLICITUD_LLAVE_PASO_UBICACION':
                                    $message = Llave_Paso::registrar_ubicacion_llave_paso($contact->id, $message);
                                    break;

                                case 'SOLICITUD_VACTOR_NOMBRE_PERSONA':
                                    $message = Vactor_Fosa_Septica::registrar_nombre_completo_vactor($contact->id, $message);
                                    break;

                                case 'SOLICITUD_VACTOR_UBICACION':
                                    $message = Vactor_Fosa_Septica::registrar_ubicacion_vactor($contact->id, $message);
                                    break;
                                case 'SOLICITUD_VACTOR_REFERENCIA':
                                    $message = Vactor_Fosa_Septica::registrar_referencia_vactor($contact->id, $message);
                                    break;

                                case 'REPORTE_FUGA_AGUA_NOMBRE_COMPLETO':

                                    $message = Fugas::registrar_nombre_pedir_ubicacion($contact->id, $message);
                                    break;

                                case 'REPORTE_FUGA_AGUA_UBICACION':
                                    $message = Fugas::registrar_ubicacion_pedir_referencia($contact->id, $message);
                                    break;
                                case 'REPORTE_FUGA_AGUA_REFERENCIA':
                                    $message = Fugas::registrar_referencia_pedir_tipo_suelo($contact->id, $message);
                                    break;
                                case 'REPORTE_FUGA_AGUA_FOTO':
                                    $message = HelpersChatController::enviarMensajeRandom(
                                        $contact->id,
                                        "⚠️ *Advertencia importante sobre tu reporte* ⚠️\n\n" .
                                        "Estás realizando el reporte de una fuga. Para poder procesarlo correctamente, es necesario que nos envíes una fotografía detallada de la fuga. 📸\n\n" .
                                        "Tu colaboración es fundamental para atender este incidente de manera eficaz. ¡Gracias por tu comprensión! 🙏"
                                    );

                                    break;
                                case 'REPORTE_DRENAJE_NOMBRE_COMPLETO':

                                    $message = Drenaje::registrar_nombre_pedir_ubicacion($contact->id, $message);
                                    break;

                                case 'REPORTE_DRENAJE_UBICACION':

                                    $message = Drenaje::registrar_ubicacion_pedir_referencia($contact->id, $message);
                                    break;

                                case 'REPORTE_DRENAJE_REFERENCIA':

                                    $message = Drenaje::registrar_referencia_pedir_tipo_suelo($contact->id, $message);
                                    break;

                                case 'REPORTE_DRENAJE_FOTO':
                                    $message = HelpersChatController::enviarMensajeRandom(
                                        $contact->id,
                                        "⚠️ *Advertencia importante sobre tu reporte* ⚠️\n\n" .
                                        "Estás realizando el reporte de un problema con el drenaje. Para poder procesarlo correctamente, es necesario que nos envíes una fotografía detallada del drenaje. 📸\n\n" .
                                        "Tu colaboración es fundamental para atender este incidente de manera eficaz. ¡Gracias por tu comprensión! 🙏"
                                    );

                                    break;
                                case 'REPORTE_ALCANTARILLA_NOMBRE_COMPLETO':

                                    $message = Drenaje::registrar_nombre_pedir_ubicacion_Alcantarilla($contact->id, $message);
                                    break;

                                case 'REPORTE_ALCANTARILLA_UBICACION':

                                    $message = Drenaje::registrar_ubicacion_pedir_referencia_Alcantarilla($contact->id, $message);
                                    break;
                                case 'REPORTE_ALCANTARILLA_REFERENCIA':

                                    $message = Drenaje::registrar_referencia_pedir_foto_Alcantarilla($contact->id, $message);
                                    break;

                                case 'REPORTE_ALCANTARILLA_FOTO':
                                    $message = HelpersChatController::enviarMensajeRandom(
                                        $contact->id,
                                        "⚠️ *Advertencia importante sobre tu reporte* ⚠️\n\n" .
                                        "Estás realizando el reporte de un problema con el drenaje. Para poder procesarlo correctamente, es necesario que nos envíes una fotografía detallada de la alcantarilla. 📸\n\n" .
                                        "Tu colaboración es fundamental para atender este incidente de manera eficaz. ¡Gracias por tu comprensión! 🙏"
                                    );

                                    break;
                                case 'REPORTE_FALTA_AGUA_NOMBRE_COMPLETO':

                                    $message = Fugas::registrar_nombre_pedir_ubicacion_FaltaDeAgua($contact->id, $message);
                                    break;

                                case 'REPORTE_FALTA_AGUA_UBICACION':

                                    $message = Fugas::registrar_ubicacion_pedir_referencia_FaltaDeAgua($contact->id, $message);
                                    break;

                                case 'REPORTE_FALTA_AGUA_REFERENCIA':

                                    $message = Fugas::registrar_referencia_terminar_FaltaDeAgua($contact->id, $message);
                                    break;

                                case 'REPORTE_PROBLEMA_OTRO_TIPO_DESCRIPCION':

                                    $message = OtroTipo::registrar_descripcion($contact->id, $message);
                                    break;

                                case 'SOLICITUD_OTRO_TIPO_UBICACION_REFERENCIA':

                                    $message = OtroTipo::registrar_referencia($contact->id, $message);
                                    break;

                                case 'REPORTE_PROBLEMA_OTRO_TIPO_NOMBRE_COMPLETO':

                                    $message = OtroTipo::registrar_nombre_completo($contact->id, $message);
                                    break;
                                case 'SOLICITUD_OTRO_TIPO_UBICACION':

                                    $message = OtroTipo::registrar_ubicacion($contact->id, $message);
                                    break;

                                default:
                                    // Opcional: manejar casos no esperados
                                    \Log::warning("Proceso no reconocido: {$contact->proceso_realizando}");
                                    break;
                            }
                            event(new ContactReplies(auth()->user(), $message, $contact));

                        } else {
                            $mensaje = strtoupper($message);
                            $saludos = ["OLA", "HOLA", "DIAS", "BUENAS", "BUENOS", "QUE TAL", "COMO ESTAS", "DIA", "BUEN", "HAY ALGUIEN", "HELLO", "TARDE", "NOCHE"];
                            $patronesAgradecimiento = ["GRACIAS", "THANK YOU", "MERCI", "DANK", "ARIGATO", "TAK", "AGRADEZCO", "ARRE"];

                            $enSaludos = array_filter($saludos, fn($saludo) => strpos($mensaje, $saludo) !== false);

                            $enAgradecimientos = array_filter($patronesAgradecimiento, fn($agradecimiento) => strpos($mensaje, $agradecimiento) !== false);

                            if ($enSaludos) {
                                $message = $contact->sendMessage($message, true, false, "TEXT", $messageID);

                            } else if ($enAgradecimientos && $contact->responseBot()) {
                               $message =  HelpersChatController::enviarMensajeRandom(
                                    $contact->id,
                                    "¡De nada! 😊✨ Si necesitas más ayuda, no dudes en preguntar. 🛠️💬"
                                );
                            } else if ($contact->responseBot()) {
                                $message = HelpersChatController::enviarMensajeRandom(
                                    $contact->id,
                                    "🤖 Recuerda que soy un bot 🤗, pero estoy aquí para ayudarte. Intenta preguntarme de otra manera, o enviarme 'HOLA' para iniciar una conersación 📝🔍."
                                );
                            }else{
                                $message = $contact->sendMessage($message, true, false, "TEXT", $messageID);
                            }

                            // event(new ContactReplies(auth()->user(), $message, $contact));
                        }

                    } else if ($type == "interactive") {
                        if ($value['messages'][0]['interactive']['type'] == "button_reply") {
                            $messageContent = $value['messages'][0]['interactive']['button_reply']['title'];
                            $messageID = $value['messages'][0]['interactive']['button_reply']['id'];
                            $contacto = $value['messages'][0]['from'];
                            // Actualizamos la asignacion del contacto
                            $contact = Contact::where('phone', $contacto)->first();
                            if ($contact->responseBot()) {
                                $message = Message::create([
                                    'fb_message_id' => $value['messages'][0]['id'],
                                    'contact_id' => $contact->id,
                                    'buttons' => '[]',
                                    'value' => 'Selecciono el boton: ' . $value['messages'][0]['interactive']['button_reply']['title'],
                                    'is_message_by_contact' => 1,
                                    'components' => '',
                                    'company_id' => 1,
                                ]);
                                event(new ContactReplies(auth()->user(), $message, $contact));

                                if ($messageID == 'FUGA_AGUA_MEDIDOR' || $messageID == 'FUGA_AGUA_CASA' || $messageID == 'FUGA_AGUA_CALLE') {

                                    $message = Fugas::comenzarProceso($contact->id, $messageID);

                                } else if ($messageID == 'DRENAJE_SE_REGRESA' || $messageID == 'DRENAJE_OBSTRUIDO') {

                                    $message = Drenaje::comenzarProceso($contact->id, $messageID);

                                } else if ($messageID == 'agree_group' || $messageID == 'not_agree_group') {

                                    $message = Registro::gracias_registrarte_volver_comenzar($contact, $messageID);

                                } else if ($messageID == 'SUELO_TERRACERIA_FUGA' || $messageID == 'SUELO_ASFALTO_FUGA' || $messageID == 'SUELO_CONCRETO_FUGA') {

                                    $message = Fugas::registrar_tipo_suelo_pedir_foto($contact, $messageID);

                                } else if ($messageID == 'SUELO_TERRACERIA_DRENAJE' || $messageID == 'SUELO_ASFALTO_DRENAJE' || $messageID == 'SUELO_CONCRETO_DRENAJE') {

                                    $message = Drenaje::registrar_tipo_suelo_pedir_foto($contact, $messageID);

                                } else if ($messageID == 'Recibido') {
                                    $message = HelpersChatController::enviarMensajeRandom(
                                        $contact->id,
                                        "✅ ¡Gracias por confirmarnos que recibiste la factura! 📄"
                                    );
                                } else if ($messageID == 'TERMINAR_PROCESO') {
                                    // if ($contact->confirmacionProceso) {
                                    $message = HelpersChatController::enviarMensajeRandom(
                                        $contact->id,
                                        "El proceso ha sido cancelado exitosamente. 😊 Si requieres asistencia adicional, estoy a tu disposición. 🤝"
                                    );
                                    $contact->proceso_realizando = null;
                                    $contact->update();
                                    // }


                                } else if ($messageID == 'FALTA_AGUA_DOMICILIO' || $messageID == 'FALTA_AGUA_COLONIA') {

                                    $message = Fugas::comenzarProcesoFaltaDeAgua($contact->id, $messageID);

                                } else if ($messageID == 'ubicacion_sucursal') {

                                    $message = MensajesInformes::enviarUbicacionesJmasInstalaciones($contact->id);

                                } else if ($messageID == 'ubicacion_oficinas') {

                                    $message = MensajesInformes::enviarUbicacionesJmasOficina($contact->id);

                                } else if ($messageContent == "Reasignar") {
                                    $message = '';
                                    if (RegistroConversacion::GetConversation($contact->id) !== 0) {
                                        $messageContent = "Tu consultor ya tomo el soporte no puedes reasignarte";

                                        $message = $contact->sendMessage($messageContent, true, false, "TEXT", $value['messages'][0]['id']);

                                        HelpersChatController::enviarMensajeRandom($contact->id, $messageContent);
                                    } else {
                                        $message = $contact->sendMessage($messageContent, true, false, "TEXT", $messageID);
                                        HelpersChatController::volverEnviarConsultores($contact->id);
                                    }
                                }
                                if ($message != '' && $message) {
                                    event(new ContactReplies(auth()->user(), $message, $contact));
                                }

                            }
                            event(new Chatlistchange($contact->id, 1));

                            //Store the message

                            try {
                                //Send the button reply ID to the bot
                                $messageButtonID = $value['messages'][0]['interactive']['button_reply']['id'];
                                // $contact->botReply($messageButtonID, $message);
                            } catch (\Throwable $th) {
                                //throw $th;
                            }

                        } elseif ($value['messages'][0]['interactive']['type'] == 'list_reply') {
                            $item_id = $value['messages'][0]['interactive']['list_reply']['id'];
                            $contacto = $value['messages'][0]['from'];
                            $contact = Contact::where('phone', $contacto)->first();
                            if ($contact->responseBot()) {
                                $message = Message::create([
                                    'fb_message_id' => $value['messages'][0]['id'],
                                    'contact_id' => $contact->id,
                                    'buttons' => '[]',
                                    'value' => 'Selecciono la opcion: ' . $value['messages'][0]['interactive']['list_reply']['title'],
                                    'is_message_by_contact' => 1,
                                    'components' => '',
                                    'company_id' => 1,
                                ]);
                                event(new ContactReplies(auth()->user(), $message, $contact));
                                switch ($item_id) {
                                    case 'informes':
                                        $message = MensajesInformes::enviarInformes($contact->id);
                                        break;

                                    case 'terminos_condiciones':
                                        $message = MensajesInformes::terminos_condiciones($contact->id);
                                        break;

                                    case 'solicitudes':
                                        $message = Solicitudes::enviarSolicitudes($contact->id);
                                        break;

                                    case 'registrarse':
                                        $message = Registro::iniciarRegistro($contact);
                                        break;

                                    case 'ubicaciones_jmas':
                                        $message = '';
                                        MensajesInformes::enviarUbicacionesJmas($contact->id);
                                        break;

                                    case 'horarios_jmas':
                                        $message = MensajesInformes::enviarHorarios($contact->id);
                                        break;

                                    case 'contratos':
                                        $message = MensajesInformes::enviarMensajeContratos($contact->id);
                                        break;

                                    case 'referencias_bancarias':
                                        $message = MensajesInformes::enviarReferenciasBancarias($contact->id);
                                        break;

                                    case 'facturacion':
                                        $message = MensajesInformes::enviarMensajeFacturacion($contact->id);
                                        break;

                                    case 'metodos_de_pago':
                                        $message = MensajesInformes::enviarMetodosPago($contact->id);
                                        break;

                                    case 'saldos':
                                        $message = MensajesInformes::enviarSaldos($contact->id);
                                        break;

                                    case 'tinacos':
                                        $message = MensajesInformes::enviarInformacionTinacos($contact->id);
                                        break;

                                    case 'descuentos':
                                        $message = MensajesInformes::enviarDescuentos($contact->id);
                                        break;

                                    case 'pipa_de_agua':
                                        $message = Pipa_Agua::pipa_de_agua($contact->id);
                                        break;

                                    case 'facturas':
                                        $message = Solicitudes::facturas($contact->id);
                                        break;

                                    case 'reconexiones':
                                        $message = Reconexiones::reconexiones($contact->id);
                                        break;

                                    case 'inspeccion_alto_consumo':
                                        $message = Solicitudes::inspeccion_alto_consumo($contact->id);
                                        break;

                                    case 'cambio_de_llave_de_paso':
                                        $message = Llave_Paso::llave_paso($contact->id);
                                        break;
                                    case 'vactor_fosa_septica':
                                        $message = Vactor_Fosa_Septica::vactor_fosa_septica($contact->id);
                                        break;

                                    case 'problema':
                                        $message = HelpersChatController::enviarReportarProblema($contact->id);
                                        break;

                                    case 'fugas':

                                        $message = Fugas::enviarTipoFugas($contact->id);
                                        break;

                                    case 'drenaje':

                                        $message = Drenaje::enviarOpcionesDrenaje($contact->id);
                                        break;

                                    case 'falta_de_agua':

                                        $message = Fugas::enviarOpcionesFaltaDeAgua($contact->id);
                                        break;

                                    case 'alcantarillado':
                                        $message = Drenaje::enviarOpcionesAlcantarilla($contact->id);
                                        break;

                                    case 'baches':
                                        $message = Baches::comenzarProcesoBaches($contact->id);
                                        break;

                                    case 'alto_consumo_inspeccion':
                                        $message = Solicitudes::inspeccion_alto_consumo($contact->id);
                                        break;

                                    case 'otros_especifique':
                                        $message = OtroTipo::comenzarProceso($contact->id);
                                        break;

                                    case 'ALCANTARILLA_DERRAME' || 'ALCANTARILLA_FALTA_TAPA':
                                        $message = Drenaje::comenzarProcesoAlcantarilla($contact->id, $item_id);
                                        break;
                                }
                                if ($message) {
                                    event(new ContactReplies(auth()->user(), $message, $contact));
                                }

                            }



                        } elseif ($value['messages'][0]['interactive']['type'] == 'nfm_reply') {
                            $contacto = $value['messages'][0]['from'];
                            // Primero obtenemos el contacto
                            $contact = Contact::where('phone', $contacto)->first();
                            // guardamos la respuesta de la encuesta
                            RespuestaEncuesta::guardarRespuestaEncuesta($contact->id, $value['messages'][0]);
                            // Guardamos el que haya contestado la ecuesta para que en la aplicacion aparezca
                            // que se contesto ls encuesta

                            $messageContent = "Contesto la encuesta";
                            $contact->eneable_auto_responses = 0;
                            $contact->save();
                            $message = $contact->sendMessage($messageContent, true, false, "TEXT", $value['messages'][0]['id']);
                            // Enviamos el agradecimiento por contestar la encuesta
                            HelpersChatController::enviarGraciasPorContestarEncuesta($contact->id);
                            // activamos las respuestas automaticas del usuario
                            $contact->eneable_auto_responses = 1;
                            $contact->save();
                            // Actualizamos el Dom
                            event(new Chatlistchange($contact->id, 1));

                        }
                    } else if ($type == "contacts" || $type == "contact") {
                        $message = $contact->sendMessage(__("Contact message is sent. But the message format is unsupported"), true, false, "TEXT", $messageID);
                    } else if ($type == "location") {


                        //return response()->json(['send' => "Location"]);
                        $urlMaps = "https://www.google.com/maps?q=" . $value['messages'][0]['location']['latitude'] . ',' . $value['messages'][0]['location']['longitude'];

                        $response = Http::withHeaders([
                            'User-Agent' => 'Sichat - Aplicaciones NG' // Reemplaza con tu información
                        ])->get('https://nominatim.openstreetmap.org/reverse', [
                                    'lat' => $value['messages'][0]['location']['latitude'],
                                    'lon' => $value['messages'][0]['location']['longitude'],
                                    'format' => 'json'
                                ]);
                        $data = $response->json();
                        $display_name = $data['display_name'];
                        $message = Message::create([
                            'fb_message_id' => $value['messages'][0]['id'],
                            'contact_id' => $contact->id,
                            'buttons' => '[]',
                            'value' => $display_name,
                            'is_message_by_contact' => 1,
                            'components' => '',
                            'company_id' => 1,
                        ]);
                        event(new ContactReplies(auth()->user(), $message, $contact));

                        if ($contact->proceso_realizando) {
                            switch ($contact->proceso_realizando) {
                                case 'REPORTE_FUGA_AGUA_UBICACION':
                                    $message = Fugas::registrar_ubicacion_pedir_referencia($contact->id, $display_name, $urlMaps);
                                    break;
                                case 'REPORTE_DRENAJE_UBICACION':
                                    $message = Drenaje::registrar_ubicacion_pedir_referencia($contact->id, $display_name, $urlMaps);
                                    break;
                                case 'REPORTE_ALCANTARILLA_UBICACION':
                                    $message = Drenaje::registrar_ubicacion_pedir_referencia_Alcantarilla($contact->id, $display_name, $urlMaps);
                                    break;
                                case 'SOLICITUD_VACTOR_UBICACION':
                                    $message = Vactor_Fosa_Septica::registrar_ubicacion_vactor($contact->id, $display_name, $urlMaps);
                                    break;
                                case 'SOLICITUD_LLAVE_PASO_UBICACION':
                                    $message = Llave_Paso::registrar_ubicacion_llave_paso($contact->id, $display_name, $urlMaps);
                                    break;
                                case 'SOLICITUD_RECONEXION_UBICACION':

                                    $message = Reconexiones::registrar_ubicacion_reconexion($contact->id, $display_name, $urlMaps);
                                    break;

                                case 'SOLICITUD_PIPA_AGUA_UBICACION':

                                    $message = Pipa_Agua::registrar_ubicacion_pipa($contact->id, $display_name, $urlMaps);
                                    break;

                                case 'REPORTE_FALTA_AGUA_UBICACION':

                                    $message = Fugas::registrar_ubicacion_pedir_referencia_FaltaDeAgua($contact->id, $display_name, $urlMaps);
                                    break;

                                case 'REPORTE_BACHES_UBICACION':

                                    $message = Baches::registrar_ubicacion_pedir_referencia($contact->id, $display_name, $urlMaps);
                                    break;

                                case 'SOLICITUD_OTRO_TIPO_UBICACION':

                                    $message = OtroTipo::registrar_ubicacion($contact->id, $display_name, $urlMaps);
                                    break;

                            }

                            event(new ContactReplies(auth()->user(), $message, $contact));

                        } else {
                            $message = $contact->sendMessage($message, true, false, "LOCATION", $messageID);
                        }
                        //Store the message
                    } else if ($type == "button") {
                        $message = $value['messages'][0]['button']['text'];
                        $contextid = $value['messages'][0]['context']['id'];
                        if ($message == "Sí, se resolvió.") {
                            $message = HelpersChatController::enviarMensajeRandom(
                                $contact->id,
                                "¡Perfecto! 😊✨ Nos alegra saber que el problema se resolvió exitosamente. 💧💙\n\nRecuerda que estamos aquí para ayudarte con lo que necesites. ¡No dudes en contactarnos en cualquier momento! 💬🤝"
                            );
                            $reporte = Reporte::where('celular', $contact->phone)
                                ->where('estatus', 'PROCESANDO')
                                ->where('context', $contextid)
                                ->get()->first();
                            $reporte->estatus = 'RESUELTO';
                            $reporte->save();

                        } else if ($message == "No, el problema persiste.") {
                            $message = HelpersChatController::enviarMensajeRandom(
                                $contact->id,
                                "Lamentamos mucho que el problema no se haya resuelto. 😔💧\n\nUno de nuestros asesores te atenderá lo antes posible para ayudarte a solucionarlo. 🙌✨\n\n¡Gracias por tu paciencia y confianza! 💙"
                            );
                            $reporte = Reporte::where('celular', $contact->phone)
                                ->where('estatus', 'PROCESANDO')
                                ->where('context', $contextid)
                                ->get()->first();
                            $reporte->estatus = 'NO_SE_RESOLVIO';
                            $reporte->save();

                        } else if ($message == "Se resolvió.") {
                            $message = HelpersChatController::enviarMensajeRandom(
                                $contact->id,
                                "¡Perfecto! 😊✨ Nos alegra saber que el problema se resolvió exitosamente. 💧💙\n\nRecuerda que estamos aquí para ayudarte con lo que necesites. ¡No dudes en contactarnos en cualquier momento! 💬🤝"
                            );
                            $solicitud = Solicitud::where('celular', $contact->phone)
                                ->where('estatus', 'PROCESANDO')
                                ->where('context', $contextid)
                                ->get()->first();
                            $solicitud->estatus = 'RESUELTO';
                            $solicitud->save();

                        } else if ($message == "No se resolvió.") {
                            $message = HelpersChatController::enviarMensajeRandom(
                                $contact->id,
                                "Lamentamos mucho que el problema no se haya resuelto. 😔💧\n\nUno de nuestros asesores te atenderá lo antes posible para ayudarte a solucionarlo. 🙌✨\n\n¡Gracias por tu paciencia y confianza! 💙"
                            );
                            $solicitud = Solicitud::where('celular', $contact->phone)
                                ->where('estatus', 'PROCESANDO')
                                ->where('context', $contextid)
                                ->get()->first();
                            $solicitud->estatus = 'NO_SE_RESOLVIO';
                            $solicitud->save();

                        } else if ($message == "Recibido") {
                            $message = HelpersChatController::enviarMensajeRandom(
                                $contact->id,
                                "✅ ¡Gracias por confirmarnos que recibiste la factura! 📄"
                            );
                        } else if ($message == "Términos y Condiciones") {
                            $message = MensajesInformes::terminos_condiciones($contact->id);
                        }
                        event(new ContactReplies(auth()->user(), $message, $contact));

                        //Store the message
                        // $message = $contact->sendMessage($message, true, false, "TEXT", $messageID);
                    }
                    $contact->last_reply_at = now();
                    $contact->save();


                }

                return response('EVENT_RECEIVED', 200);


            } catch (\Throwable $th) {
                \Log::debug($th->getMessage());
                return response()->json(['send' => false, 'error' => $th, 'data' => $request]);
            }









        } else {
            return response()->json(['send' => false]);
        }
    }

    public function downloadAndStoreMedia($mediaID, $ext = ".jpg")
    {
        $url = self::$facebookAPI . $mediaID;
        $accessToken = $this->getToken();
        $company = $this->getCompany();
        try {




            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $accessToken,
                'Content-Type' => 'application/json',
            ])->get($url);


            $statusCode = $response->status();
            $content = json_decode($response->body(), true);

            $responseImage = $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $accessToken,
            ])->get($content['url']);

            $fileContents = $responseImage->getBody()->getContents();


            // Define the local path where you want to save the downloaded file
            if (config('settings.use_s3_as_storage', false)) {
                //S3 - store per company
                $fileName = 'uploads/media/received/' . $company->id . "/" . $content['id'] . $ext;
                $path = Storage::disk('s3')->put($fileName, $fileContents, 'public');
                return Storage::disk('s3')->url($fileName);
            } else {
                //Regular
                $localPath = public_path('uploads/media/' . $content['id'] . $ext);
                file_put_contents($localPath, $fileContents);
                $url = config('app.url') . "/uploads/media/" . $content['id'] . $ext;
                return preg_replace('#(https?:\/\/[^\/]+)\/\/#', '$1/', $url);
            }









        } catch (\Exception $e) {
            dd($e);
            // Handle the exception
        }
    }

    public function verifyWebhook(Request $request, $tokenViaURL)
    {
        // Parse params from the webhook verification request
        $mode = $request->query('hub_mode');
        $token = $request->query('hub_verify_token');
        $challenge = $request->query('hub_challenge');

        $token = PersonalAccessToken::findToken($token);
        if ($token) {
            // Token is valid
            // Proceed with the request handling
            // Check if a token and mode were sent
            if ($mode && $token) {
                // Check the mode and token sent are correct
                if ($mode === 'subscribe') {
                    $user = User::findOrFail($token->tokenable_id);
                    Auth::login($user);

                    //Company
                    $company = $this->getCompany();

                    $company->setConfig('whatsapp_webhook_verified', "yes");

                    // Respond with 200 OK and challenge token from the request
                    return response($challenge, 200);
                } else {
                    // Respond with '403 Forbidden' if verify tokens do not match
                    return response()->json([], 403);
                }
            }
        } else {
            return response()->json([], 403);
        }




    }



    public function loadTemplatesFromWhatsApp($after = "")
    {
        $url = self::$facebookAPI . $this->getAccountID() . '/message_templates';
        $queryParams = [
            'fields' => 'name,category,language,quality_score,components,status',
            'limit' => 100
        ];
        if ($after != "") {
            $queryParams['after'] = $after;
        }
        $headers = [
            'Authorization' => 'Bearer ' . $this->getToken()
        ];

        $response = Http::withHeaders($headers)->get($url, $queryParams);




        // Handle the response here
        if ($response->successful()) {
            $responseData = $response->json();


            //On success - remove all previous templates, if on initial call
            if ($after == "") {
                Template::query()->each(function ($model) {
                    try {
                        $model->delete();
                    } catch (\Throwable $th) {

                    }

                });
            }



            $companyID = $this->getCompany()->id;
            foreach ($responseData['data'] as $key => $template) {
                //Insert new messages
                try {
                    $data = [
                        'name' => $template['name'],
                        'category' => $template['category'],
                        'language' => $template['language'],
                        'status' => $template['status'],
                        'id' => $template['id'],
                        'company_id' => 1,
                        'components' => json_encode($template['components']),
                    ];
                    $template = Template::upsert($data, 'id', ['components', 'status']);
                } catch (\Throwable $th) {
                    //throw $th;
                    //dd($th);
                }
            }

            //Check if we have more templates
            if ($responseData['paging'] && isset($responseData['paging']['next']) && isset($responseData['paging']['cursors']['after'])) {
                return $this->loadTemplatesFromWhatsApp($responseData['paging']['cursors']['after']);
            } else {
                return true;
            }

            // Process $responseData as needed
        } else {
            // Handle error response
            return false;
        }
    }



    public function sendMessageToWhatsApp(Message $message, $contact)
    {
        $url = self::$facebookAPI . $this->getPhoneID() . '/messages';
        $accessToken = $this->getToken();

        if (strlen($accessToken > 5)) {
            try {

                $dataToSend = [
                    'messaging_product' => 'whatsapp',
                    'to' => $contact->phone, // Add recipient information
                ];

                if (strlen($message->buttons) > 5) {
                    //Interactive message
                    $dataToSend['type'] = 'interactive';


                    $dataToSend['interactive']['body'] = [
                        'text' => $message->value,
                    ];

                    //Header if available
                    if (strlen($message->header_text) > 0) {
                        $dataToSend['interactive']['header'] = [
                            'type' => 'text',
                            'text' => $message->header_text,
                        ];
                    }

                    //Footer if available
                    if (strlen($message->footer_text) > 0) {
                        $dataToSend['interactive']['footer'] = [
                            'text' => $message->footer_text,
                        ];
                    }

                    //->is_cta is runtime property
                    if ($message->is_cta) {
                        unset($message->is_cta); //We don't need this, since will cause error
                        $dataToSend['interactive']['type'] = "cta_url";
                        $dataToSend['interactive']['action'] = array_values(json_decode($message->buttons, true))[0];

                    } else {
                        //Reply buttons
                        $dataToSend['interactive']['type'] = "button";
                        $dataToSend['interactive']['action']['buttons'] = array_values(json_decode($message->buttons, true));

                    }
                } else if (strlen($message->value) > 0) {
                    //Text message
                    $dataToSend['type'] = 'text';

                    if (config('settings.is_demo', false)) {
                        //Demo
                        $dataToSend['text'] = [
                            'body' => "[THIS IS DEMO] " . $message->value,
                            'preview_url' => true,
                        ];
                    } else {
                        //Production
                        $dataToSend['text'] = [
                            'body' => $message->value,
                            'preview_url' => true,
                        ];
                    }




                } else if (strlen($message->header_image) > 0) {
                    $dataToSend['type'] = 'image';
                    $dataToSend['image'] = [
                        'link' => $message->header_image
                    ];
                } else if (strlen($message->header_video) > 0) {
                    if (substr($message->header_video, -4) === ".mp3") {
                        $dataToSend['type'] = 'audio';
                        $dataToSend['audio'] = [
                            'link' => $message->header_video
                        ];
                    } else {
                        $dataToSend['type'] = 'video';
                        $dataToSend['video'] = [
                            'link' => $message->header_video
                        ];
                    }

                } else if (strlen($message->header_audop) > 0) {
                    $dataToSend['type'] = 'audio';
                    $dataToSend['audio'] = [
                        'link' => $message->header_audio
                    ];

                } else if (strlen($message->header_document) > 0) {
                    $path = parse_url($message->header_document, PHP_URL_PATH);
                    $filename = pathinfo($path, PATHINFO_FILENAME);
                    $dataToSend['type'] = 'document';
                    $dataToSend['document'] = [
                        'link' => $message->header_document,
                        "filename" => $filename,
                    ];
                }
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $accessToken,
                    'Content-Type' => 'application/json',
                ])->post($url, $dataToSend);

                $statusCode = $response->status();
                $content = json_decode($response->body(), true);
                //If error

                if (isset($content['error'])) {
                    $message->error = $content['error']['message'];
                    $message->update();
                } else {
                    $message->fb_message_id = $content['messages'][0]['id'];
                    $message->update();
                }

                // Handle the response as needed based on $statusCode and $content
            } catch (\Exception $e) {
                // Handle the exception
                //if debug mode is on
                if (config('app.debug', false)) {
                    dd($e);
                }
            }
        }



    }


}
