<?php
namespace Modules\Wpbox\Http\Controllers;

use App\Models\Config;
use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Modules\Wpbox\Traits\Whatsapp;

class VerificarHorariosController extends Controller
{
    use Whatsapp;

    public static function checkSchedule($mensajeSeAsigno)
    {
        $hora_entrada = Config::where('key', 'hora_entrada')->first()->value;
        $hora_entrada_comida = Config::where('key', 'hora_entrada_comida')->first()->value;
        $hora_salida_comida = Config::where('key', 'hora_salida_comida')->first()->value;
        $hora_salida = Config::where('key', 'hora_salida')->first()->value;

        $now = Carbon::now()->format('H:i');

        // Convertir las horas a objetos Carbon para facilitar la comparación
        $horaEntrada = Carbon::createFromFormat('H:i', $hora_entrada);
        $horaEntradaComida = Carbon::createFromFormat('H:i', $hora_entrada_comida);
        $horaSalidaComida = Carbon::createFromFormat('H:i', $hora_salida_comida);
        $horaSalida = Carbon::createFromFormat('H:i', $hora_salida);

        $horaActual = Carbon::createFromFormat('H:i', $now);

        // Formatear las horas para enviar en el mensaje
        $horaSalidaComidaFormatted = Carbon::createFromFormat('H:i', $hora_salida_comida)->format('g:i A');
        $horaEntradaComidaFormatted = Carbon::createFromFormat('H:i', $hora_entrada_comida)->format('g:i A');
        $horaEntradaFormatted = Carbon::createFromFormat('H:i', $hora_entrada)->format('g:i A');
        $horaSalidaFormatted = Carbon::createFromFormat('H:i', $hora_salida)->format('g:i A');

        // Verificar si está en horario de trabajo
        if ($horaActual->between($horaEntrada, $horaSalida)) {
            // Verificar si está en horario de comida
            if ($horaActual->between($horaEntradaComida, $horaSalidaComida)) {
                if($mensajeSeAsigno){
                    return "Hola, soy Sidev, el asistente virtual de Aplicaciones NG.\n\nSe asigno su soporte pero estamos en nuestro horario de comida, se le atendera despues de las $horaSalidaComidaFormatted.\n\nGracias por su comprensión.";
                }else{
                    return "Hola, soy Sidev, el asistente virtual de Aplicaciones NG.\n\nEstamos en nuestro horario de comida y no podemos atenderle en este momento. Por favor, espere hasta después de las $horaSalidaComidaFormatted.\n\nGracias por su comprensión.";
                }
            } else {
                return '';
            }
        } else {
            if($mensajeSeAsigno){
                return "Hola, soy Sidev, el asistente virtual de Aplicaciones NG.\n\nSe asigno tu soporte, se te atendera lo más pronto posible en horario de $horaEntradaFormatted a $horaEntradaComidaFormatted y de $horaSalidaComidaFormatted a $horaSalidaFormatted.\n\nGracias por su comprensión.";
            }else{
                return "Hola, soy Sidev, el asistente virtual de Aplicaciones NG.\n\nNuestro horario de atención es de $horaEntradaFormatted a $horaEntradaComidaFormatted y de $horaSalidaComidaFormatted a $horaSalidaFormatted. Por favor, contáctenos durante nuestro horario de atención.\n\nGracias por su comprensión.";
            }
        }
    }
    public static function enviarDisponibilidad($id_contact,$mensajeSeAsigno)
    {
        $mensaje  = static::checkSchedule($mensajeSeAsigno);
        if($mensaje && $mensaje!=''){
            HelpersChatController::enviarMensajeRandom($id_contact,$mensaje);
            return true;
        }
        return false;
    }
}
