<?php

namespace Modules\Wpbox\Http\Controllers;

use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\User;
use App\Models\UserPermissionStaff;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class TimesChatController extends Controller
{
    use Whatsapp;

    public static function TimeConversation(Request $request)
    {
        try {
            $contact = Contact::find($request->all()['contact_id']);
            if(auth()->user()->id != $contact->user_id){
                return response()->json([
                    'status' => false,
                    'errMsg' => 'No puedes iniciar conversacion que esta asignada a otro consultor',
                ]);
            }
            $conversacion = RegistroConversacion::StartConversation(auth()->user()->id, $request->all()['contact_id']);
            if ($conversacion) {
                $createAt = Carbon::parse($conversacion->create_at);
                $currentTime = Carbon::now();
                $conversacion = $createAt->diffInSeconds($currentTime);
            } else {
                $conversacion = 0;
            }
            return $conversacion;
        } catch (\Throwable $th) {
            return $th;
        }
    }

    public static function dataForGraphs(Request $request)
    {
        // Obtener el mes y año actuales
        $currentMonth = Carbon::now()->month;
        $currentYear = Carbon::now()->year;

        // Verificar si el usuario tiene el rol de 'owner'
        if (auth()->user()->hasRole('owner')) {
            // Obtener todos los usuarios con el rol específico
            $users = \DB::select("
                SELECT u.id, u.name, u.descripcion
                FROM users u
                JOIN model_has_roles mhr ON mhr.model_id = u.id
                JOIN users_permissions_staffs ups ON ups.user_id = u.id
                WHERE mhr.role_id = 4
            ");

            // Inicializar los arreglos para etiquetas y datos
            $consultants = [];
            $conversations = [];
            $durations = [];

            // Recorrer cada usuario para obtener los datos necesarios
            foreach ($users as $user) {
                $consultants[] = $user->name;

                // Obtener la cantidad de conversaciones del usuario en el mes actual
                $conversationCount = RegistroConversacion::where('id_user', $user->id)
                    ->whereMonth('create_at', $currentMonth)
                    ->whereYear('create_at', $currentYear)
                    ->count();
                $conversations[] = $conversationCount;

                // Obtener el promedio de duración de las conversaciones del usuario en el mes actual en minutos
                $averageDuration = RegistroConversacion::where('id_user', $user->id)
                    ->whereMonth('create_at', $currentMonth)
                    ->whereYear('create_at', $currentYear)
                    ->avg('tiempo_conversacion');
                $durations[] = $averageDuration; // Convertir a minutos
            }

            // Formatear los datos para la respuesta
            $data = [
                'consultants' => $consultants,
                'conversations' => $conversations,
                'duration' => $durations
            ];

            // Devolver los datos como JSON
            return response()->json($data);
        } else {
            // Para otros usuarios, obtener sus contactos y estadísticas de conversaciones
            $user_id = auth()->user()->id;

            // Obtener los registros de conversación del usuario en el mes actual
            $conversationRecords = RegistroConversacion::where('id_user', $user_id)
                ->whereMonth('create_at', $currentMonth)
                ->whereYear('create_at', $currentYear)
                ->select('id_contacto')
                ->distinct()
                ->get();

            // Inicializar los arreglos para etiquetas y datos
            $contactNames = [];
            $contactConversations = [];
            $contactDurations = [];

            // Recorrer cada contacto para obtener los datos necesarios
            foreach ($conversationRecords as $record) {
                $contact = Contact::find($record->id_contacto);
                if ($contact) {
                    $contactNames[] = $contact->name;

                    // Obtener la cantidad de conversaciones con el contacto en el mes actual
                    $conversationCount = RegistroConversacion::where('id_user', $user_id)
                        ->where('id_contacto', $contact->id)
                        ->whereMonth('create_at', $currentMonth)
                        ->whereYear('create_at', $currentYear)
                        ->count();
                    $contactConversations[] = $conversationCount;

                    // Obtener el promedio de duración de las conversaciones con el contacto en el mes actual en minutos
                    $averageDuration = RegistroConversacion::where('id_user', $user_id)
                        ->where('id_contacto', $contact->id)
                        ->whereMonth('create_at', $currentMonth)
                        ->whereYear('create_at', $currentYear)
                        ->avg('tiempo_conversacion');
                    $contactDurations[] = $averageDuration; // Convertir a minutos
                }
            }

            // Formatear los datos para la respuesta
            $data = [
                'contacts' => $contactNames,
                'conversations' => $contactConversations,
                'duration' => $contactDurations
            ];

            // Devolver los datos como JSON
            return response()->json($data);
        }
    }
}
