<?php

namespace Modules\Wpbox\Http\Controllers\Solicitudes;
use Carbon\Carbon;
use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\RespuestaEncuesta;
use App\Models\Solicitud;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class Pipa_Agua extends Controller
{
    use Whatsapp;
    public static function pipa_de_agua($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "SOLICITUD_PIPA_AGUA_DESCRIPCION";
            $contact->update();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "🚚 *Solicitud de Pipa de Agua*\n\n" .
                "Para poder ayudarte con la solicitud de tu pipa de agua, por favor, danos más detalles sobre el motivo de la solicitud. 😃\n\n" .
                "*¿Para qué necesitas la pipa de agua?*\n" .
                "Proporciona una breve descripción y con gusto te apoyaremos en el proceso.";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();


            return $message;


        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_descripcion_pipa($id_contact, $desription)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "SOLICITUD_PIPA_AGUA_NOMBRE_COMPLETO";
            $contact->update();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            \Log::debug('descripcion de pipa', [$desription]);
            $solicitud = Solicitud::create([
                'tipo_solicitud' => 'PIPA',
                'celular' => $contact->phone,
                'descripcion_solicitud' => $desription,
                'estatus' => 'REGISTRANDO',
            ]);
            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "🚚 *Solicitud de Pipa de Agua*\n\n" .
                "Gracias por proporcionar la descripción de tu solicitud. 😃\n\n" .
                "Ahora, por favor, indícanos el *nombre completo* de la persona a la que se destinará la pipa de agua.";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_nombre_completo_pipa($id_contact, $nombre_completo)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "SOLICITUD_PIPA_AGUA_UBICACION";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $solicitud = Solicitud::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('tipo_solicitud', 'PIPA')
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $solicitud->nombre_persona = $nombre_completo;
            $solicitud->update();

            $texto = "🚚 *Solicitud de Pipa de Agua*\n\n" .
                "Gracias por proporcionarnos el nombre completo. 😃\n\n" .
                "Ahora, por favor, indícanos la *ubicación* en la que necesitas la pipa de agua.\n\n" .
                "Por favor, describe la ubicación en texto, no compartas la ubicación como coordenadas o enlaces. ¡Gracias! 😊";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "location_request_message",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "name" => "send_location"
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_ubicacion_pipa($id_contact, $ubicacion, $urlMaps = null)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "SOLICITUD_PIPA_AGUA_REFERENCIA";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $solicitud = Solicitud::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->first();
            $solicitud->ubicacion = $ubicacion;
            $solicitud->url_maps = $urlMaps;
            $solicitud->update();

            $texto = "🚚 *Solicitud de Pipa de Agua*\n\n" .
                "¡Gracias por compartirnos tu ubicación! 😊\n\n" .
                "Para ubicar mejor el lugar podrías decirnos una referencia amplia 😃\n\n";



            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_referencia($contact, $referencia)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact->proceso_realizando = null;
            $contact->save();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $solicitud = Solicitud::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->first();

            $solicitud->referencia = $referencia;
            $solicitud->estatus = 'PENDIENTE';
            $solicitud->folio = "PA" . $solicitud->id;
            $solicitud->save();

            $texto = "🚚  ¡Gracias por compartirnos una referencia del lugar! 😊\n\n" .
                "Tu solicitud ha sido registrada exitosamente. En cuanto sea posible, nuestro equipo la atenderá con gusto. 😃\n\n" .
                "🔖 *Tu folio de seguimiento es:* `{$solicitud->folio}`\n\n" .
                "¡Agradecemos tu paciencia y estamos para ayudarte en lo que necesites! 🚰";



            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error en registrar referencia de pipa de agua ==============");
            \Log::error($e->getMessage());
        }
    }
}
