<?php

namespace Modules\Wpbox\Http\Controllers;
use Carbon\Carbon;
use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\RespuestaEncuesta;
use App\Models\Solicitud;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class Solicitudes extends Controller
{
    use Whatsapp;
    public static function enviarSolicitudes($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $rows = [
                [
                    "id" => "pipa_de_agua",
                    "title" => "🚛 Pipa de agua",
                    "description" => "Solicita el servicio de suministro de agua."
                ],
                [
                    "id" => "cambio_de_llave_de_paso",
                    "title" => "🔧 Llave de paso",
                    "description" => "Pide el cambio o reparación de tu llave de paso."
                ],
                [
                    "id" => "facturas",
                    "title" => "📄 Facturas",
                    "description" => "Consulta o descarga tus facturas."
                ],
                [
                    "id" => "reconexiones",
                    "title" => "🔌 Reconexiones",
                    "description" => "Solicita la reconexión de tu servicio."
                ],
                [
                    "id" => "vactor_fosa_septica",
                    "title" => "💩 Vactor ",
                    "description" => "Pide un 💩 Vactor Fosa séptica."
                ],
                [
                    "id" => "inspeccion_alto_consumo",
                    "title" => "📊 Alto consumo",
                    "description" => "Solicita una inspección por alto consumo."
                ],
                // [
                //     "id" => "tinacos",
                //     "title" => "🛢️ Tinacos",
                //     "description" => "Consulta servicios relacionados con tinacos."
                // ],
            ];

            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "list",
                            "header" => [
                                "type" => "text",
                                "text" => "JMAS"
                            ],
                            "body" => [
                                "text" => "🔍 *Selecciona una opción de SOLICITUDES para recibir más detalles*"
                            ],
                            "action" => [
                                "button" => "Seleccionar",
                                "sections" => [
                                    [
                                        "rows" => $rows
                                    ],
                                ]
                            ]
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = "JMAS";
            $message->contact_id = $id_contact;
            $message->components = json_encode($rows);
            $message->buttons = "";
            $message->status = 1;
            $message->value = "Mensaje automático, selecciona una opción de SOLICITUDES";
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function facturas($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';


            $texto = "📄 *¡Recuerda facturar tus pagos!*\n\n" .
                "✅ *Detalles importantes:*\n" .
                "- Puedes facturar cualquier pago realizado durante el mes en curso.\n" .
                "- El plazo límite para facturar es el último día del mes a las 14:00 hrs. Después de esa hora, no se generarán facturas.\n\n" .
                "💳 *Reflejo de tu pago:*\n\n" .
                "- El tiempo en que tu pago se vea reflejado depende del canal utilizado.\n\n" .
                "- ¿Necesitas que sea inmediato? Usa alguno de estos métodos:\n\n" .
                "       • Nuestra app \n*“JMAS CUAHTÉMOC”*\n\n" .
                "       • Cajeros automáticos JMAS\n\n" .
                "       • Cajeros automáticos de Pagos Digitales\n\n" .
                "       • Cajas en nuestras oficinas y sucursales\n\n" .
                "📑 *Documentos necesarios:*\n" .
                "- Tu constancia de situación fiscal.\n\n" .
                "Si tienes dudas o necesitas ayuda, estamos aquí para apoyarte. 😊";




            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "cta_url",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "name" => "cta_url",
                                "parameters" => [
                                    "display_text" => " Pagar en línea",
                                    "url" => "https://www.jmascuauhtemoc.gob.mx/"
                                ]
                            ]
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = "JMAS";
            $message->contact_id = $id_contact;
            $message->components = '';
            $message->buttons = "";
            $message->status = 1;
            $message->value = $texto;
            $message->save();

            return $message;


        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function inspeccion_alto_consumo($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Mensaje principal
            $texto = "⚠️ *¿Crees que tu consumo es demasiado alto?*\n\n" .
                "No te preocupes, estamos aquí para ayudarte. Acude a nuestras oficinas o sucursal, y con gusto uno de nuestros asesores te ayudará a encontrar una solución a tu problema.\n\n" .
                "🏠💧 *¿Necesitas obtener un tinaco?*\n\n" .
                "Para hacerlo, acude a nuestras oficinas generales y presenta los siguientes documentos:\n\n" .
                "• 🧾 *Recibo de agua* a nombre del titular.\n" .
                "• 🆔 *Identificación oficial.*\n\n" .
                "¡Con gusto te ayudaremos en el proceso! 😊\n\n" .
                "🔍 *Haz clic en una de las opciones para ver la ubicación más cercana:*";

            // Botones
            $buttons = [
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "ubicacion_oficinas",
                        "title" => "📍 Oficinas Generales"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "ubicacion_sucursal",
                        "title" => "📍 Sucursal"
                    ]
                ]
            ];

            // Enviar mensaje interactivo con botones
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "button",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "buttons" => $buttons
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = "JMAS";
            $message->contact_id = $id_contact;
            $message->components = '';
            $message->buttons = json_encode($buttons);
            $message->status = 1;
            $message->value = $texto;
            $message->save();
            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }

}
