<?php

namespace Modules\Wpbox\Http\Controllers\Reportes;
use App\Models\Reporte;
use Carbon\Carbon;
use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\RespuestaEncuesta;
use App\Models\Solicitud;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class OtroTipo extends Controller
{
    use Whatsapp;
    public static function comenzarProceso($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "REPORTE_PROBLEMA_OTRO_TIPO_DESCRIPCION";
            $contact->update();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "🚚 *Reportar alguna otra situacion*\n\n" .
                "Para poder ayudarte con el problema que tienes podrias explicarnos ampliamente ¿Cual es el problema que tienes?😃";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_descripcion($id_contact, $desription)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "REPORTE_PROBLEMA_OTRO_TIPO_NOMBRE_COMPLETO";
            $contact->update();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            Reporte::create([
                'tipo_reporte' => 'OTRO TIPO',
                'celular' => $contact->phone,
                'descripcion_reporte' => $desription,
                'estatus' => 'REGISTRANDO',
            ]);
            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "Gracias por compartirnos cual es el problema que tienes." .
                "Para ayudarte con tu problema, por favor indícanos el *nombre completo* del titular o el *número de servicio*\n\n" .
                "📝 Esto nos permitirá atender tu solicitud de manera más rápida y eficiente. ¡Gracias por tu cooperación! 😊";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_nombre_completo($id_contact, $nombre_completo)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "SOLICITUD_OTRO_TIPO_UBICACION";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->nombre_o_servicio = $nombre_completo;
            $reporte->update();

            $texto = "🚰 Gracias por proporcionarnos el *nombre completo* del titular o el *número de servicio*. Ahora necesitamos la *ubicación exacta* donde se presenta el problema\n\n" .
                "📍 Por favor, compártenos tu ubicación o indícanos una dirección detallada.\n\n" .
                "📝 Esto nos permitirá procesar tu solicitud lo más pronto posible. ¡Gracias por tu apoyo! 😊";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_ubicacion($id_contact, $ubicacion, $urlMaps = null)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = 'SOLICITUD_OTRO_TIPO_UBICACION_REFERENCIA';
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->ubicacion = $ubicacion;
            $reporte->url_maps = $urlMaps;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir la ubicacion donde se encuentra tu problema!* 😊\n\n" .
                "Para ubicar mejor el lugar nos podrías compartir una referencia del lugar porfavor";



            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_referencia($id_contact, $referencia)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = null;
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->referencia = $referencia;
            $reporte->estatus = 'PENDIENTE';
            $reporte->folio = "O" . $reporte->id;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir la referencia donde se encuentra tu problema!* 😊\n\n" .
                "El reporte de tu problema ha sido registrado exitosamente. En cuanto sea posible, nuestro equipo lo atenderá con gusto. 😃\n\n" .
                "🔖 *Tu folio de seguimiento es:* `{$reporte->folio}`\n\n" .
                "¡Agradecemos tu paciencia y estamos para ayudarte en lo que necesites! 🚰";



            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }


}
