<?php

namespace Modules\Wpbox\Http\Controllers\Reportes;
use App\Models\Reporte;
use Carbon\Carbon;
use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\RespuestaEncuesta;
use App\Models\Solicitud;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class Fugas extends Controller
{
    use Whatsapp;
    public static function enviarTipoFugas($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Botones para las opciones con iconos
            $buttons = [
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "FUGA_AGUA_MEDIDOR",
                        "title" => "💧🔧 Fuga en Medidor"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "FUGA_AGUA_CASA",
                        "title" => "🏠💧 Fuga en Casa"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "FUGA_AGUA_CALLE",
                        "title" => "🚧💧 Fuga en Calle"
                    ]
                ]
            ];
            $texto = "💦 *Reporte de Fugas*\n\nSelecciona el tipo de fuga que deseas reportar:";
            // Enviar mensaje con botones interactivos
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "button",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "buttons" => $buttons
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = json_encode($buttons);
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function comenzarProceso($id_contact, $tipo_fuga)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::where('id', $id_contact)->get()->first();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            if ($tipo_fuga == 'FUGA_AGUA_MEDIDOR') {
                $descripcion = 'Fuga de agua en medidor';
            }
            if ($tipo_fuga == 'FUGA_AGUA_CASA') {
                $descripcion = 'Fuga de agua en la casa';
            }
            if ($tipo_fuga == 'FUGA_AGUA_CALLE') {
                $descripcion = 'Fuga de agua en la calle';
            }
            if ($tipo_fuga == 'FUGA_AGUA_CALLE') {
                $contact->proceso_realizando = 'REPORTE_FUGA_AGUA_UBICACION';

                $texto = "🚚 Gracias por proporcionarnos el *nombre completo* del titular o el *numero de servicio*. Ahora necesitamos la *ubicación exacta* donde esta la fuga.\n\n" .
                    "📍 Por favor, compártenos tu ubicación o indícanos una dirección detallada.\n\n" .
                    "📝 Esto nos permitirá procesar tu solicitud lo más pronto posible. ¡Gracias por tu apoyo! 😊";


                // Enviar el mensaje a través de la API de WhatsApp
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                    'Content-Type' => 'application/json',
                ])->post($url, [
                            "messaging_product" => "whatsapp",
                            "recipient_type" => "individual",
                            "to" => $contact->phone,
                            "type" => "interactive",
                            "interactive" => [
                                "type" => "location_request_message",
                                "body" => [
                                    "text" => $texto
                                ],
                                "action" => [
                                    "name" => "send_location"
                                ]
                            ]
                        ]);

            } else {
                $contact->proceso_realizando = 'REPORTE_FUGA_AGUA_NOMBRE_COMPLETO';
                $texto = "🚚 *Reporte de fuga*\n\n" .
                    "Para ayudarte con tu reporte de fuga, por favor indícanos el *nombre completo* del titular o el *número de servicio*\n\n" .
                    "📝 Esto nos permitirá atender tu solicitud de manera más rápida y eficiente. ¡Gracias por tu cooperación! 😊";

                // Enviar el mensaje a través de la API de WhatsApp
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                    'Content-Type' => 'application/json',
                ])->post($url, [
                            "messaging_product" => "whatsapp",
                            "recipient_type" => "individual",
                            "to" => $contact->phone,
                            "type" => "text",
                            "text" => [
                                "body" => $texto
                            ]
                        ]);
            }
            Reporte::create([
                'tipo_reporte' => $tipo_fuga,
                'celular' => $contact->phone,
                'descripcion_reporte' => $descripcion,
                'estatus' => 'REGISTRANDO',
            ]);
            $contact->update();

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function registrar_nombre_pedir_ubicacion($id_contact, $nombre_completo)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "REPORTE_FUGA_AGUA_UBICACION";
            $contact->update();

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->nombre_o_servicio = $nombre_completo;
            $reporte->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "🚚 Gracias por proporcionarnos el *nombre completo* del titular o el *numero de servicio*. Ahora necesitamos la *ubicación exacta* donde esta la fuga.\n\n" .
                "📍 Por favor, compártenos tu ubicación o indícanos una dirección detallada.\n\n" .
                "📝 Esto nos permitirá procesar tu solicitud lo más pronto posible. ¡Gracias por tu apoyo! 😊";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "location_request_message",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "name" => "send_location"
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_ubicacion_pedir_referencia($id_contact, $ubicacion, $urlMaps = null)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_FUGA_AGUA_REFERENCIA";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->ubicacion = $ubicacion;
            $reporte->url_maps = $urlMaps;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir tu ubicación!* 😊\n\n" .
                "Agradecemos mucho tu colaboración. Si nos pudieras compartir una referencia amplia del lugar te lo agradeceriamos mucho.";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_referencia_pedir_tipo_suelo($id_contact, $referencia)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_FUGA_AGUA_TIPO_SUELO";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->referencia = $referencia;
            $reporte->update();

            $texto = "*¡Gracias por compartirnos la referencia del lugar!* 😊\n\n" .
                "Para ayudarnos a llevar un mejor registro, por favor selecciona el tipo de suelo donde se encuentra la fuga de agua. Aquí tienes las opciones: 👇\n\n" .
                "🟫 *Concreto*: Pavimento color gris con paneles cuadrados grandes a lo largo de la calle.\n" .
                "🛣️ *Asfalto*: Pavimento color negro liso (Chapopote).\n" .
                "🌾 *Terracería*: Calle sin ningún tipo de pavimento.\n\n" .
                "¡Agradecemos mucho tu ayuda! 🙌";

            // Enviar el mensaje a través de la API de WhatsApp
            $buttons = [
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "SUELO_CONCRETO_FUGA",
                        "title" => "🟫 Concreto"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "SUELO_ASFALTO_FUGA",
                        "title" => "🛣️ Asfalto"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "SUELO_TERRACERIA_FUGA",
                        "title" => "🌾 Terracería"
                    ]
                ]
            ];

            // Enviar mensaje con botones interactivos
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "button",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "buttons" => $buttons
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = json_encode($buttons);
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error en registrar referencia pedir tipo suelo en fuga de agua ==============");
            \Log::error($e->getMessage());
        }
    }
    public static function registrar_tipo_suelo_pedir_foto($contact, $tipo_suelo)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;

            $contact->proceso_realizando = "REPORTE_FUGA_AGUA_FOTO";
            $contact->save();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            if ($tipo_suelo == "SUELO_TERRACERIA_FUGA") {

                $tipo_suelo = "Terracería";

            } else if ($tipo_suelo == "SUELO_ASFALTO_FUGA") {

                $tipo_suelo = "Asfalto";

            } else if ($tipo_suelo == "SUELO_CONCRETO_FUGA") {

                $tipo_suelo = "Concreto";

            }
            $reporte->tipo_suelo = $tipo_suelo;
            $reporte->update();

            $texto = "*¡Gracias por compartirnos el tipo de suelo!* 😊\n\n" .
                "Agradecemos mucho tu colaboración. Ahora, por favor, envíanos una fotografía detallada de la fuga para que podamos ayudarte de manera más precisa. 🛠️📸";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error en registrar tipo suelo pedir foto fuga de agua ==============");
            \Log::error($e->getMessage());
        }
    }
    public static function registrar_foto_terminar_solicitud($id_contact, $urlLink)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = null;
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->foto_reporte = $urlLink;
            $reporte->estatus = 'PENDIENTE';
            $reporte->folio = "FU" . $reporte->id;
            $reporte->update();

            $texto = "🛠️📸 *¡Gracias por compartir la foto de la fuga!* 😊\n\n" .
                "Tu reporte de fuga ha sido *registrado exitosamente*. En cuanto sea posible, nuestro equipo la atenderá con gusto. 😃\n\n" .
                "🔖 *Tu folio de seguimiento es:* `{$reporte->folio}`\n\n" .
                "¡Agradecemos tu paciencia y estamos para ayudarte en lo que necesites! 🚰";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = '';
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }

    public static function enviarOpcionesFaltaDeAgua($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Botones para las opciones con iconos
            $buttons = [
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "FALTA_AGUA_DOMICILIO",
                        "title" => "🏠 En mi domicilio"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "FALTA_AGUA_COLONIA",
                        "title" => "🌆 En mi colonia"
                    ]
                ]
            ];

            $texto = "💧 *Reporte de Falta de Agua*\n\nPor favor, selecciona dónde no hay agua:";
            // Enviar mensaje con botones interactivos
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "button",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "buttons" => $buttons
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = json_encode($buttons);
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function comenzarProcesoFaltaDeAgua($id_contact, $tipo_falta_agua)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::where('id', $id_contact)->get()->first();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            $contact->proceso_realizando = 'REPORTE_FALTA_AGUA_NOMBRE_COMPLETO';
            $contact->update();
            if ($tipo_falta_agua == 'FALTA_AGUA_COLONIA') {
                $descripcion = 'Reporta de falta de agua en una colonia';
            }
            if ($tipo_falta_agua == 'FALTA_AGUA_DOMICILIO') {
                $descripcion = 'Reporta de falta de agua en un domicilio';
            }
            Reporte::create([
                'tipo_reporte' => $tipo_falta_agua,
                'celular' => $contact->phone,
                'descripcion_reporte' => $descripcion,
                'estatus' => 'REGISTRANDO',
            ]);

            $texto = "🚰 *Reporte de problema de falta de agua*\n\n" .
                "Para ayudarte con tu reporte de problema con la falta de agua, por favor indícanos el *nombre completo* del titular o el *número de servicio*. 📝\n\n" .
                "Esto nos permitirá atender tu solicitud de manera más rápida y eficiente. ¡Gracias por tu cooperación! 😊";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function registrar_nombre_pedir_ubicacion_FaltaDeAgua($id_contact, $nombre_completo)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "REPORTE_FALTA_AGUA_UBICACION";
            $contact->update();

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->nombre_o_servicio = $nombre_completo;
            $reporte->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "🚰 Gracias por proporcionarnos el *nombre completo* del titular o el *número de servicio*. Ahora necesitamos la *ubicación exacta* donde se presenta el problema de la falta de agua.\n\n" .
                "📍 Por favor, compártenos tu ubicación o indícanos una dirección detallada.\n\n" .
                "📝 Esto nos permitirá procesar tu solicitud lo más pronto posible. ¡Gracias por tu apoyo! 😊";



            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "location_request_message",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "name" => "send_location"
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_ubicacion_pedir_referencia_FaltaDeAgua($id_contact, $ubicacion, $urlMaps = null)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = 'REPORTE_FALTA_AGUA_REFERENCIA';
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->ubicacion = $ubicacion;
            $reporte->url_maps = $urlMaps;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir la ubicacion del problema con la falta de agua!* 😊\n\n" .
                "Ahora si pudieras compartirnos la descripción de una referencia";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_referencia_terminar_FaltaDeAgua($id_contact, $referencia)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = null;
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->referencia = $referencia;
            $reporte->estatus = 'PENDIENTE';
            $reporte->folio = 'FA' . $reporte->id;
            $reporte->update();
            $texto = "📍 *¡Gracias por compartirnos una referencia!* 😊\n\n" .
                "Tu reporte de falta de agua con folio: `{$reporte->folio}` ha sido registrado exitosamente. En cuanto sea posible, nuestro equipo lo atenderá con gusto. 😃\n\n" .
                "¡Agradecemos tu paciencia y estamos para ayudarte en lo que necesites! 🚰";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }



}
