<?php

namespace Modules\Wpbox\Http\Controllers\Reportes;
use Carbon\Carbon;
use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\RespuestaEncuesta;
use App\Models\Solicitud;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class Falta_agua extends Controller
{
    use Whatsapp;
    public static function enviarOpcionesFaltaDeAgua($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Botones para las opciones con iconos
            $buttons = [
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "DRENAJE_SE_REGRESA",
                        "title" => "🔄 Se está regresando"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "DRENAJE_OBSTRUIDO",
                        "title" => "⚠️ Está obstruido"
                    ]
                ]
            ];
            // Enviar mensaje con botones interactivos
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "button",
                            "body" => [
                                "text" => "🚰 *Reporte de Problemas con el Drenaje*\n\nSelecciona el tipo de problema con el drenaje que deseas reportar:"
                            ],
                            "action" => [
                                "buttons" => $buttons
                            ]
                        ]
                    ]);

            $content = json_decode($response->body(), true);

            // Manejo opcional de respuesta
            if ($response->successful()) {
                // \Log::info("Mensaje enviado correctamente.");
            } else {
                \Log::error("Error al enviar el mensaje: " . json_encode($content));
            }

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }




}
