<?php

namespace Modules\Wpbox\Http\Controllers\Reportes;
use App\Models\Reporte;
use Carbon\Carbon;
use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\RespuestaEncuesta;
use App\Models\Solicitud;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class Drenaje extends Controller
{
    use Whatsapp;
    public static function enviarOpcionesDrenaje($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Botones para las opciones con iconos
            $buttons = [
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "DRENAJE_SE_REGRESA",
                        "title" => "🔄 Se está regresando"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "DRENAJE_OBSTRUIDO",
                        "title" => "⚠️ Está obstruido"
                    ]
                ]
            ];
            $texto = "🚰 *Reporte de Problemas con el Drenaje*\n\nSelecciona el tipo de problema con el drenaje que deseas reportar:";
            $dataToSend = [
                "messaging_product" => "whatsapp",
                "recipient_type" => "individual",
                "to" => $sendPhoneNumber,
                "type" => "interactive",
                "interactive" => [
                    "type" => "button",
                    "body" => [
                        "text" => $texto
                    ],
                    "action" => [
                        "buttons" => $buttons
                    ]
                ]
            ];
            // Enviar mensaje con botones interactivos
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, $dataToSend);

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = "JMAS";
            $message->contact_id = $id_contact;
            $message->components = '';
            $message->buttons = "[]";
            $message->status = 1;
            $message->value = $texto;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function enviarOpcionesAlcantarilla($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->value('value');
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->value('value');
            $sendPhoneNumber = Contact::where('id', $id_contact)->value('phone');
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Opciones de la lista
            $sections = [
                [
                    "title" => "Ver opciones",
                    "rows" => [
                        [
                            "id" => "ALCANTARILLA_DERRAME",
                            "title" => "Derrame",
                            "description" => "⚠️ Reporta un derrame en el alcantarillado."
                        ],
                        [
                            "id" => "ALCANTARILLA_FALTA_TAPA",
                            "title" => "Tapa alcantarilla",
                            "description" => "🚽 Reporta de la falta de tapa en una alcantarilla."
                        ]
                    ]
                ]
            ];

            // Mensaje a enviar con lista interactiva
            $dataToSend = [
                "messaging_product" => "whatsapp",
                "recipient_type" => "individual",
                "to" => $sendPhoneNumber,
                "type" => "interactive",
                "interactive" => [
                    "type" => "list",
                    "header" => [
                        "type" => "text",
                        "text" => "🚰 Problemas con el Alcantarillado"
                    ],
                    "body" => [
                        "text" => "Selecciona una opción para reportar un problema:"
                    ],
                    "footer" => [
                        "text" => "Gracias por ayudarnos a mejorar la ciudad."
                    ],
                    "action" => [
                        "button" => "Ver opciones",
                        "sections" => $sections
                    ]
                ]
            ];


            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json;',
            ])->post($url, $dataToSend);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->header_text = "🚰 Problemas con el Alcantarillado";
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = "Selecciona una opción para reportar un problema:";
            $message->footer_text = "Gracias por ayudarnos a mejorar la ciudad.";
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("Error en enviarOpciones: ", [$e->getMessage(), $e->getTrace()]);
        }
    }
    public static function comenzarProceso($id_contact, $tipo_drenaje)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::where('id', $id_contact)->get()->first();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            $contact->proceso_realizando = 'REPORTE_DRENAJE_NOMBRE_COMPLETO';
            $contact->update();
            if ($tipo_drenaje == 'DRENAJE_SE_REGRESA') {
                $descripcion = 'El drenaje se esta regresando';
            }
            if ($tipo_drenaje == 'DRENAJE_OBSTRUIDO') {
                $descripcion = 'El drenaje esta obstruido';
            }
            Reporte::create([
                'tipo_reporte' => $tipo_drenaje,
                'celular' => $contact->phone,
                'descripcion_reporte' => $descripcion,
                'estatus' => 'REGISTRANDO',
            ]);

            $texto = "🚰 *Reporte de Problemas con el Drenaje*\n\n" .
                "Para ayudarte con tu reporte de problemas en el drenaje, por favor indícanos el *nombre completo* del titular o el *número de servicio*. 📝\n\n" .
                "Esto nos permitirá atender tu solicitud de manera más rápida y eficiente. ¡Gracias por tu cooperación! 😊";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function registrar_nombre_pedir_ubicacion($id_contact, $nombre_completo)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "REPORTE_DRENAJE_UBICACION";
            $contact->update();

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->nombre_o_servicio = $nombre_completo;
            $reporte->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "🚰 Gracias por proporcionarnos el *nombre completo* del titular o el *número de servicio*. Ahora necesitamos la *ubicación exacta* donde se presenta el problema con el drenaje.\n\n" .
                "📍 Por favor, compártenos tu ubicación o indícanos una dirección detallada.\n\n" .
                "📝 Esto nos permitirá procesar tu solicitud lo más pronto posible. ¡Gracias por tu apoyo! 😊";



            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "location_request_message",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "name" => "send_location"
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_ubicacion_pedir_referencia($id_contact, $ubicacion, $urlMaps = null)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_DRENAJE_REFERENCIA";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->ubicacion = $ubicacion;
            $reporte->url_maps = $urlMaps;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir tu ubicación!* 😊\n\n" .
                "Agradecemos mucho tu colaboración. Ahora, por favor, una descripcion de referencia para poder ubicarnos mejor";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_referencia_pedir_tipo_suelo($id_contact, $referencia)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_DRENAJE_TIPO_SUELO";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->referencia = $referencia;
            $reporte->update();

            $texto = "*¡Gracias por compartirnos la referencia del lugar!* 😊\n\n" .
                "Para ayudarnos a llevar un mejor registro, por favor selecciona el tipo de suelo donde se encuentra el problema con el drenaje. Aquí tienes las opciones: 👇\n\n" .
                "🟫 *Concreto*: Pavimento color gris con paneles cuadrados grandes a lo largo de la calle.\n" .
                "🛣️ *Asfalto*: Pavimento color negro liso (Chapopote).\n" .
                "🌾 *Terracería*: Calle sin ningún tipo de pavimento.\n\n" .
                "¡Agradecemos mucho tu ayuda! 🙌";

            // Enviar el mensaje a través de la API de WhatsApp
            $buttons = [
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "SUELO_CONCRETO_DRENAJE",
                        "title" => "🟫 Concreto"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "SUELO_ASFALTO_DRENAJE",
                        "title" => "🛣️ Asfalto"
                    ]
                ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "SUELO_TERRACERIA_DRENAJE",
                        "title" => "🌾 Terracería"
                    ]
                ]
            ];

            // Enviar mensaje con botones interactivos
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "button",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "buttons" => $buttons
                            ]
                        ]
                    ]);
            $statusCode = $response->status();
            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = json_encode($buttons);
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_tipo_suelo_pedir_foto($contact, $tipo_suelo)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;

            $contact->proceso_realizando = "REPORTE_DRENAJE_FOTO";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            if ($tipo_suelo == "SUELO_TERRACERIA_DRENAJE") {
                $tipo_suelo = "Terracería";
            } else if ($tipo_suelo == "SUELO_ASFALTO_DRENAJE") {
                $tipo_suelo = "Asfalto";
            } else if ($tipo_suelo == "SUELO_CONCRETO_DRENAJE") {
                $tipo_suelo = "Concreto";
            }
            $reporte->tipo_suelo = $tipo_suelo;
            $reporte->update();

            $texto = "*¡Gracias por compartirnos la referencia del lugar!* 😊\n\n" .
                "Agradecemos mucho tu colaboración. Ahora, por favor, envíanos una fotografía detallada del problema con el drenaje para que podamos ayudarte de manera más precisa. 🛠️📸";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_foto_terminar_solicitud($id_contact, $urlLink)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = null;
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->foto_reporte = $urlLink;
            $reporte->estatus = 'PENDIENTE';
            $reporte->folio = "D" . $reporte->id;
            $reporte->update();

            $texto = "🛠️📸 *¡Gracias por compartir la foto del problema con el drenaje!* 😊\n\n" .
                "Tu reporte de drenaje ha sido registrado exitosamente. En cuanto sea posible, nuestro equipo lo atenderá con gusto. 😃\n\n" .
                "🔖 *Tu folio de seguimiento es:* `{$reporte->folio}`\n\n" .
                "¡Agradecemos tu paciencia y estamos para ayudarte en lo que necesites! 🚰";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = '';
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }




    public static function comenzarProcesoAlcantarilla($id_contact, $tipo_alcantarilla)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::where('id', $id_contact)->get()->first();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            $contact->proceso_realizando = 'REPORTE_ALCANTARILLA_NOMBRE_COMPLETO';
            $contact->update();
            if ($tipo_alcantarilla == 'ALCANTARILLA_DERRAME') {
                $descripcion = 'Reporta un derrame en el alcantarillado';
            }
            if ($tipo_alcantarilla == 'ALCANTARILLA_FALTA_TAPA') {
                $descripcion = 'Reporta de la falta de tapa en una alcantarilla';
            }
            Reporte::create([
                'tipo_reporte' => $tipo_alcantarilla,
                'celular' => $contact->phone,
                'descripcion_reporte' => $descripcion,
                'estatus' => 'REGISTRANDO',
            ]);

            $texto = "🚰 *Reporte de Problemas con la alcantarilla*\n\n" .
                "Para ayudarte con tu reporte de problema con la alcantarilla, por favor indícanos el *nombre completo* del titular o el *número de servicio*. 📝\n\n" .
                "Esto nos permitirá atender tu solicitud de manera más rápida y eficiente. ¡Gracias por tu cooperación! 😊";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = "JMAS";
            $message->contact_id = $id_contact;
            $message->components = '';
            $message->buttons = "[]";
            $message->status = 1;
            $message->value = $texto;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function registrar_nombre_pedir_ubicacion_Alcantarilla($id_contact, $nombre_completo)
    {
        try {
            // \Log::debug($nombre_completo);
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "REPORTE_ALCANTARILLA_UBICACION";
            $contact->update();

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->nombre_o_servicio = $nombre_completo;
            $reporte->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "🚰 Gracias por proporcionarnos el *nombre completo* del titular o el *número de servicio*. Ahora necesitamos la *ubicación exacta* donde se presenta el problema con la alcantarilla.\n\n" .
                "📍 Por favor, compártenos tu ubicación o indícanos una dirección detallada.\n\n" .
                "📝 Esto nos permitirá procesar tu solicitud lo más pronto posible. ¡Gracias por tu apoyo! 😊";



            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "location_request_message",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "name" => "send_location"
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_ubicacion_pedir_referencia_Alcantarilla($id_contact, $ubicacion, $urlMaps = null)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_ALCANTARILLA_REFERENCIA";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->ubicacion = $ubicacion;
            $reporte->url_maps = $urlMaps;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir tu ubicación!* 😊\n\n" .
                "Agradecemos mucho tu colaboración. Ahora, por favor, envianos una referencia para poder ubicar mejor el lugar";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_referencia_pedir_foto_Alcantarilla($id_contact, $referencia)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_ALCANTARILLA_FOTO";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->referencia = $referencia;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir una referncia del lugar!* 😊\n\n" .
                "Agradecemos mucho tu colaboración. Ahora, por favor, envíanos una fotografía detallada del problema con la alcantarilla para que podamos ayudarte de manera más precisa. 🛠️📸";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_foto_terminar_solicitud_Acantarilla($id_contact, $urlLink)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = null;
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->foto_reporte = $urlLink;
            $reporte->estatus = 'PENDIENTE';
            $reporte->folio = "A" . $reporte->id;
            $reporte->update();

            $texto = "🛠️📸 *¡Gracias por compartir la foto del problema con la alcantarilla!* 😊\n\n" .
                "Tu reporte de drenaje ha sido registrado exitosamente. En cuanto sea posible, nuestro equipo lo atenderá con gusto. 😃\n\n" .
                "🔖 *Tu folio de seguimiento es:* `{$reporte->folio}`\n\n" .
                "¡Agradecemos tu paciencia y estamos para ayudarte en lo que necesites! 🚰";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = '';
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }




}
