<?php

namespace Modules\Wpbox\Http\Controllers\Reportes;
use App\Models\Reporte;
use Carbon\Carbon;
use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\RespuestaEncuesta;
use App\Models\Solicitud;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class Baches extends Controller
{
    use Whatsapp;
    public static function comenzarProcesoBaches($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::where('id', $id_contact)->get()->first();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            $contact->proceso_realizando = 'REPORTE_BACHES_NOMBRE_COMPLETO';
            $contact->update();
            $descripcion = 'Reporte de baches';
            Reporte::create([
                'tipo_reporte' => "REPORTE_BACHES",
                'celular' => $contact->phone,
                'descripcion_reporte' => $descripcion,
                'estatus' => 'REGISTRANDO',
            ]);

            $texto = "🚰 *Reporte de baches*\n\n" .
                "Para ayudarte con tu reporte de problemas de baches, por favor indícanos el *nombre completo* del titular o el *número de servicio*. 📝\n\n" .
                "Esto nos permitirá atender tu solicitud de manera más rápida y eficiente. ¡Gracias por tu cooperación! 😊";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = '';
            $message->contact_id = $id_contact;
            $message->components = '';
            $message->buttons = "[]";
            $message->status = 1;
            $message->value = $texto;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function registrar_nombre_pedir_ubicacion_baches($id_contact, $nombre_completo)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $contact->proceso_realizando = "REPORTE_BACHES_UBICACION";
            $contact->update();

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->nombre_o_servicio = $nombre_completo;
            $reporte->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de solicitud de pipa de agua
            $texto = "🚰 Gracias por proporcionarnos el *nombre completo* del titular o el *número de servicio*. Ahora necesitamos la *ubicación exacta* donde se presenta el problema con el bache o baches.\n\n" .
                "📍 Por favor, compártenos tu ubicación o indícanos una dirección detallada.\n\n" .
                "📝 Esto nos permitirá procesar tu solicitud lo más pronto posible. ¡Gracias por tu apoyo! 😊";



            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "location_request_message",
                            "body" => [
                                "text" => $texto
                            ],
                            "action" => [
                                "name" => "send_location"
                            ]
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_ubicacion_pedir_referencia($id_contact, $ubicacion, $urlMaps = null)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_BACHE_REFERENCIA";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->ubicacion = $ubicacion;
            $reporte->url_maps = $urlMaps;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir tu ubicación!* 😊\n\n" .
                "Agradecemos mucho tu colaboración. Ahora, por favor, una descripcion de referencia para poder ubicarnos mejor";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_referencia_pedir_foto($id_contact, $referencia)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_BACHE_FOTO";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->referencia = $referencia;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir tu ubicación!* 😊\n\n" .
                "Agradecemos mucho tu colaboración. Ahora, por favor, envíanos una fotografía del bache o baches que deseas reportar para que podamos ayudarte de manera más precisa. 🛠️📸";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_foto_bache_pedir_foto_establcimiento($id_contact, $urlink)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = "REPORTE_BACHE_FOTO_ESTABLECIMIENTO";
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->foto_reporte = $urlink;
            $reporte->update();

            $texto = "📍 *¡Gracias por compartir la foto detallada del problema!* 😊\n\n" .
                "Tu colaboración es muy valiosa para nosotros. Ahora, por favor, envíanos una fotografía de algún establecimiento o lugar de referencia pública que nos ayude a ubicar la zona. 🛠️📸";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = '';
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function registrar_foto_terminar_solicitud($id_contact, $urlLink)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $contact->proceso_realizando = null;
            $contact->update();

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $reporte = Reporte::where('celular', $contact->phone)
                ->whereDate('created_at', Carbon::today())
                ->where('estatus', 'REGISTRANDO')
                ->latest()
                ->first();
            $reporte->foto_context_lugar = $urlLink;
            $reporte->estatus = 'PENDIENTE';
            $reporte->folio = "B" . $reporte->id;
            $reporte->update();

            $texto = "🛠️📸 *¡Gracias por compartir la foto del lugar público para ayudarnos a ubicar el problema!* 😊\n\n" .
                "Tu reporte de bache ha sido registrado exitosamente. Nuestro equipo lo atenderá a la brevedad posible. 😃\n\n" .
                "🔖 *Tu folio de seguimiento es:* `{$reporte->folio}`\n\n" .
                "¡Agradecemos tu paciencia y estamos aquí para ayudarte en lo que necesites! 🚗💨";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = '';
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
}
