<?php

namespace Modules\Wpbox\Http\Controllers;

use App\Models\Config;
use App\Models\RegistroConversacion;
use App\Models\RespuestaEncuesta;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Events\ContactReplies;
use Modules\Wpbox\Models\Message;
use Illuminate\Support\Facades\Storage;
use Modules\Wpbox\Models\Reply;
use Modules\Wpbox\Models\Template;
use Modules\Wpbox\Traits\Whatsapp;
use Illuminate\Support\Facades\Validator;
use Modules\Wpbox\Events\Chatlistchange;

class MensajesInformes extends Controller
{
    use Whatsapp;
    public static function enviarInformes($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $rows = [
                [
                    "id" => "ubicaciones_jmas",
                    "title" => "📍 Ubicaciones JMAS",
                    "description" => "Encuentra las oficinas más cercanas."
                ],
                [
                    "id" => "horarios_jmas",
                    "title" => "⏰ Horarios",
                    "description" => "Consulta los horarios de atención."
                ],
                [
                    "id" => "contratos",
                    "title" => "📑 Contratos",
                    "description" => "Solicita información sobre contratos."
                ],
                [
                    "id" => "referencias_bancarias",
                    "title" => "🏦 Referencias bancarias",
                    "description" => "Consulta tus referencias bancarias."
                ],
                [
                    "id" => "facturacion",
                    "title" => "📄 Facturación",
                    "description" => "Accede a la información de facturación."
                ],
                [
                    "id" => "metodos_de_pago",
                    "title" => "💳 Métodos de pago",
                    "description" => "Conoce los métodos de pago disponibles."
                ],
                [
                    "id" => "saldos",
                    "title" => "💰 Saldos",
                    "description" => "Consulta el saldo de tu cuenta."
                ],
                [
                    "id" => "tinacos",
                    "title" => "🛢️ Tinacos",
                    "description" => "Consulta servicios relacionados con tinacos."
                ],
                [
                    "id" => "descuentos",
                    "title" => "🎉 Descuentos",
                    "description" => "Averigua si aplicas a algún descuento."
                ],
            ];

            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "interactive",
                        "interactive" => [
                            "type" => "list",
                            "header" => [
                                "type" => "text",
                                "text" => "JMAS"
                            ],
                            "body" => [
                                "text" => "📋 *Elige una opción de INFORMES para obtener más detalles y la información que necesitas.*"
                            ],
                            "action" => [
                                "button" => "Seleccionar",
                                "sections" => [
                                    [
                                        "rows" => $rows
                                    ],
                                ]
                            ]
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = "JMAS";
            $message->contact_id = $id_contact;
            $message->components = json_encode($rows);
            $message->buttons = "";
            $message->status = 1;
            $message->value = "Mensaje automático, selecciona una opción de INFORMES";
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e);
        }
    }
    public static function enviarUbicacionesJmas($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->first()->value;
            $whatsappPermanentAccessToken = Config::where('key', 'whatsapp_permanent_access_token')->first()->value;
            $contact = Contact::where('id', $id_contact)->first();
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $ubicaciones = [
                [
                    "latitude" => "28.39399212693978",
                    "longitude" => "-106.87854460518005",
                    "name" => "Junta Municipal de Agua y Saneamiento de Cuauhtémoc Chihuahua",
                    "address" => "Xochimilco 1870, Amp Lerdo, 31520 Cuauhtémoc, Chih."
                ],
                [
                    "latitude" => "28.407644982014258",
                    "longitude" => "-106.86335727790909",
                    "name" => "Vicente Guerrero 500, Zona Centro, 31500 Cuauhtémoc, Chih.",
                    "address" => "Vicente Guerrero 500, Zona Centro, 31500 Cuauhtémoc, Chih."
                ]
            ];

            foreach ($ubicaciones as $ubicacion) {
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $whatsappPermanentAccessToken,
                    'Content-Type' => 'application/json',
                ])->post($url, [
                            "messaging_product" => "whatsapp",
                            "to" => $contact->phone,
                            "type" => "location",
                            "location" => [
                                "latitude" => $ubicacion['latitude'],
                                "longitude" => $ubicacion['longitude'],
                                "name" => $ubicacion['name'],
                                "address" => $ubicacion['address']
                            ]
                        ]);

                $content = json_decode($response->body(), true);
                $message = new Message();

                if (isset($content['messages'])) {
                    $message->fb_message_id = $content['messages'][0]['id'];
                    $message->error = "";
                } else {
                    $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
                }

                $message->created_at = now();
                $message->header_text = "Ubicación enviada";
                $message->contact_id = $id_contact;
                $message->components = json_encode($ubicacion);
                $message->buttons = "";
                $message->status = 1;
                $message->value = "Ubicación de la JMAS: " . $ubicacion['name'];
                $message->save();

                event(new ContactReplies(auth()->user(), $message, $contact));

            }
        } catch (\Exception $e) {
            \Log::error($e->getMessage());
        }
    }
    public static function enviarUbicacionesJmasOficina($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->first()->value;
            $whatsappPermanentAccessToken = Config::where('key', 'whatsapp_permanent_access_token')->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $ubicacion =
                [
                    "latitude" => "28.39399212693978",
                    "longitude" => "-106.87854460518005",
                    "name" => "Junta Municipal de Agua y Saneamiento de Cuauhtémoc Chihuahua",
                    "address" => "Xochimilco 1870, Amp Lerdo, 31520 Cuauhtémoc, Chih."
                ];

            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccessToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "to" => $sendPhoneNumber,
                        "type" => "location",
                        "location" => [
                            "latitude" => $ubicacion['latitude'],
                            "longitude" => $ubicacion['longitude'],
                            "name" => $ubicacion['name'],
                            "address" => $ubicacion['address']
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();

            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = "Ubicación enviada";
            $message->contact_id = $id_contact;
            $message->components = json_encode($ubicacion);
            $message->buttons = "";
            $message->status = 1;
            $message->value = "Ubicación de la JMAS: " . $ubicacion['name'];
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error($e->getMessage());
        }
    }
    public static function enviarUbicacionesJmasInstalaciones($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->first()->value;
            $whatsappPermanentAccessToken = Config::where('key', 'whatsapp_permanent_access_token')->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            $ubicacion =
                [
                    "latitude" => "28.40691698415622",
                    "longitude" => "-106.86624503709821",
                    "name" => "Junta Municipal de Agua JMAS",
                    "address" => "Av. Ignacio Allende 71, Zona Centro, 31500 Cuauhtémoc, Chih."
                ];

            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccessToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "to" => $sendPhoneNumber,
                        "type" => "location",
                        "location" => [
                            "latitude" => $ubicacion['latitude'],
                            "longitude" => $ubicacion['longitude'],
                            "name" => $ubicacion['name'],
                            "address" => $ubicacion['address']
                        ]
                    ]);

            $content = json_decode($response->body(), true);
            $message = new Message();

            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            $message->created_at = now();
            $message->header_text = "Ubicación enviada";
            $message->contact_id = $id_contact;
            $message->components = json_encode($ubicacion);
            $message->buttons = "";
            $message->status = 1;
            $message->value = "Ubicación de la JMAS: " . $ubicacion['name'];
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error($e->getMessage());
        }
    }
    public static function terminos_condiciones($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccessToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para los horarios con emojis y formato
            $terminos_y_condiciones = "📢 *TÉRMINOS Y CONDICIONES*\n\n"
    . "El presente servicio es un asistente virtual automatizado de la *Junta Municipal de Agua y Saneamiento de Cuauhtémoc (JMAS)*, diseñado para proporcionar información y recibir reportes de incidencias.\n\n"
    . "🔹 *1️⃣ Uso del Servicio*\n"
    . "- Este bot tiene fines exclusivamente informativos y operativos. No sustituye la atención personalizada en oficinas o canales oficiales.\n"
    . "- Cualquier solicitud, consulta o reporte realizado a través del bot será procesado conforme a la disponibilidad operativa y de la plataforma.\n\n"
    . "🔹 *2️⃣ Limitaciones de Responsabilidad*\n"
    . "- *Exactitud de la Información:* La información proporcionada por el bot es referencial y puede estar sujeta a cambios sin previo aviso. JMAS no garantiza la precisión, vigencia o disponibilidad de los datos proporcionados.\n"
    . "- *Errores del Usuario:* JMAS no se hace responsable por datos incorrectos ingresados por el usuario ni por decisiones tomadas con base en la información obtenida en este canal.\n"
    . "- *Disponibilidad del Servicio:* El funcionamiento del bot depende de plataformas de terceros, como WhatsApp, y de la infraestructura tecnológica disponible. JMAS no garantiza la disponibilidad ininterrumpida del servicio.\n"
    . "- *Casos de Fuerza Mayor:* JMAS no se hace responsable por fallas derivadas de situaciones ajenas a su control, como problemas de conectividad, interrupciones en el servicio de WhatsApp, fallas en sistemas externos o eventos de fuerza mayor.\n\n"
    . "🔹 *3️⃣ Privacidad y Protección de Datos*\n"
    . "- *Uso de Datos:* La información proporcionada por los usuarios será utilizada exclusivamente para la gestión de consultas, solicitudes y reportes, de conformidad con las políticas internas de JMAS.\n"
    . "- *Confidencialidad:* Los datos personales no serán compartidos con terceros, excepto en los siguientes casos:\n"
    . "  -      Requerimiento legal o judicial.\n"
    . "  -      Órdenes de autoridades competentes.\n"
    . "  -      Casos en los que el usuario solicite explícitamente compartir su información.\n"
    . "- *Seguridad:* JMAS adopta medidas razonables para proteger la información de los usuarios, pero no puede garantizar la seguridad absoluta en plataformas externas.\n\n"
    . "🔹 *4️⃣ Aceptación de Términos*\n"
    . "- Al continuar utilizando este servicio, el usuario acepta expresa e incondicionalmente los presentes términos y condiciones. En caso de no estar de acuerdo, el usuario debe abstenerse de interactuar con el bot.\n\n"
    . "Para más información, puedes contactar a *Junta Municipal de Agua y Saneamiento de Cuauhtémoc* a través de los canales oficiales.";

            // Enviar mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccessToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "text",
                        "text" => [
                            "body" => $terminos_y_condiciones
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $terminos_y_condiciones); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function enviarHorarios($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccessToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para los horarios con emojis y formato
            $texto = "*Horarios de Atención* 📅\n\n" .
                "¡Hola! Aquí tienes los horarios de atención disponibles para nuestros servicios:\n\n" .
                "🌐 *Oficinas Generales*: 08:00 – 15:00 hrs.\n" .
                "🏢 *Oficina Sucursal*: 08:00 – 15:00 hrs.\n" .
                "💳 *Cajeros Automáticos en Oficinas Generales*: 08:00 – 20:00 hrs.\n" .
                "🏦 *Cajeros Automáticos en Sucursal*: 08:00 – 20:00 hrs.\n\n" .
                "¡Te esperamos! 😊\n" .
                "_Si tienes alguna duda, no dudes en contactarnos._";

            // Enviar mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccessToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }

    public static function enviarMensajeContratos($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccessToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de contratos con emojis y formato
            $texto = "*📄 Requisitos para realizar un contrato nuevo* \n\n" .
                "¡Hola! Para realizar un contrato nuevo, puedes presentarte en nuestras *oficinas* o en nuestra *sucursal*. Para completar el trámite, necesitarás presentar los siguientes documentos en *original* y *copia*:\n\n" .
                "- 🪪 Identificación oficial\n" .
                "- 🏠 Comprobante de domicilio\n" .
                "- 📑 Comprobante de pago del predial o escritura de la propiedad\n" .
                "- 🛣️ Calle y número oficial\n" .
                "- 📐 Plano catastral de la propiedad\n" .
                "- 📸 Foto del terreno o construcción\n" .
                "- 🚰 Foto de la toma de agua\n\n" .
                "*Asegúrate de tener todos estos documentos listos para agilizar tu trámite.*\n\n" .
                "*¡Te esperamos! 😊*";

            // Enviar mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccessToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }

    public static function enviarReferenciasBancarias($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccessToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para las referencias bancarias
            $texto = "💳 *Información de Referencias Bancarias*:\n\n" .
                "_Recuerda verificar los datos antes de realizar cualquier transacción._\n\n" .
                "*¡Gracias por tu atención! 😊*\n\n" .
                "📌 *Opciones de pago:*\n\n" .
                "1️⃣ *Por convenio*:\n\n" .
                "- *Santander*: 0010467\n" .
                "- *Bancomer*: 1827146\n\n" .
                "2️⃣ *Por transferencia bancaria (CLABE)*:\n\n" .
                "- *Santander*: 014094655099126546\n" .
                "- *Bancomer*: 012914002018271466\n\n" .
                "⚠️ *Nota importante:*\n" .
                "Para pagar por convenio o por transferencia bancaria, utilice la referencia que viene en su recibo. Debe considerar que dicho pago se refleja en JMAS al siguiente día hábil de haberlo realizado.";


            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccessToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "image",
                        "image" => [
                            "link" => "https://sichat.facturador-jmas.com/uploads/media/foto_referencia.png",
                            "caption" => $texto,
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }

    public static function enviarMensajeFacturacion($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para la facturación
            $texto = "📢 *¡Hola! Queremos recordarte cómo puedes realizar tu facturación de manera sencilla:* \n\n" .
                "✅ *Facturación del mes:*\n" .
                "• Puedes facturar cualquier pago realizado dentro del mes en curso.\n" .
                "• El plazo límite para facturar es el último día hábil del mes a las 14:00 hrs. Después de esa hora, no será posible generar facturas.\n\n" .
                "💳 *¿Hiciste tu pago recientemente?*\n" .
                "• El tiempo en que tu pago se refleje dependerá del canal que hayas utilizado.\n" .
                "• *¿Quieres agilizarlo?* Puedes hacerlo de forma inmediata usando:\n" .
                "  • Nuestra app *\"JMAS CUAUHTÉMOC* https://www.jmascuauhtemoc.gob.mx/\n\n" .
                "  • Cajeros automáticos *JMAS*\n" .
                "  • Cajeros de *pagos digitales*\n" .
                "  • Las cajas de nuestras *oficinas y sucursales*.\n\n" .
                "📑 *¿Qué necesitas para facturar?*\n" .
                "• Tu *constancia de situación fiscal*.\n\n" .
                "Si tienes alguna duda o necesitas más ayuda, estamos aquí para ti. *¡Gracias por confiar en nosotros!* 😊";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }

    public static function enviarMetodosPago($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje de métodos de pago
            $texto = "💳 *¿Dónde puedes realizar tu pago?*\n\n" .
                "*Aquí te compartimos los puntos disponibles para realizar tu pago, junto con el tiempo promedio en que se verá reflejado:* \n\n" .
                "🏢 *Oficinas y Sucursales:*\n" .
                "• Cajas en nuestras *oficinas y sucursal* (INMEDIATO)\n" .
                "• Cajeros automáticos *JMAS* (INMEDIATO)\n\n" .
                "📍 *Otros puntos de pago:*\n" .
                "• Cajeros automáticos de *Pagos Digitales Chihuahua* (INMEDIATO)\n" .
                "• *Tiendas OXXO* (3 días hábiles)\n\n" .
                "📱 *¿Quieres mayor comodidad?*\n" .
                "¡Realiza tu pago desde nuestra app! *https://play.google.com/store/apps/details?id=jmas.cuauhtemoc.utility.app*\n\n" .
                "Si tienes alguna duda o necesitas más información, no dudes en contactarnos. 😊";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }

    public static function enviarSaldos($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            $texto = "💳 *Consulta tu saldo fácilmente!* 💡\n\nPara consultar tu saldo, por favor envíanos tu *NOMBRE COMPLETO* (como aparece en la parte superior de tu recibo 🧾). ¡Estamos aquí para ayudarte! 😊";

            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "image",
                        "image" => [
                            "link" => "https://sichat.facturador-jmas.com/uploads/media/foto_nombre.jpg",
                            "caption" => $texto,
                        ]
                    ]);

            $contact->proceso_realizando = "SOLICITANDO_SALDO";
            $contact->update();

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            // $message->update_at = now();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
                //dd($content);
            }
            // Guardar el mensaje
            $clean_message = str_replace("\n", '', $texto);
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function consultarSaldo($id_contact, $nombre_completo)
    {
        try {
            set_time_limit(120);
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $contact = Contact::find($id_contact);

            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Consultar el saldo de la persona
            $response = Http::withHeaders([
                'Content-Type' => 'application/json',
                'signature' => 'd513974e1d9082f1baa0edd58e8b38182e22040066e70e5ef1a427dc31c1f6d1',
            ])->timeout(60)->post('https://facturador-jmas.com/backend/api/getSaldo', [
                        "nombre_cliente" => $nombre_completo
                    ]);

            $saldoData = json_decode($response->body(), true);
            $saldos = $saldoData['dataset'] ?? [];
            $cuentas = '';
            foreach ($saldos as $saldo) {
                $cuentas .= "\n *Cuenta:* `{$saldo['cuenta']}` *Saldo:* `{$saldo['saldo']}`";
            }
            // Preparar el mensaje basado en el saldo
            $mensaje = count($saldos) > 0
                ? "El saldo de tu cuenta o cuentas es: 💰" . $cuentas . ".\n\n¡Gracias por consultar! Si necesitas algo más, no dudes en enviar un mensaje para poder ayudarte. 😊"
                : "No se encontraron registros de saldo asociados a tu cuenta. Por favor, verifica tu información o contáctanos si necesitas ayuda. 🤝";

            // Enviar el mensaje por WhatsApp
            $whatsappResponse = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $contact->phone,
                        "type" => "text",
                        "text" => [
                            "body" => $mensaje
                        ]
                    ]);

            $contact->proceso_realizando = null;
            $contact->update();

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $mensaje); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $contact->id;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;
        } catch (\Exception $e) {
            \Log::error("=============== Error en consultar saldo class Mensajes Informes ==============");
            \Log::error($e->getMessage());
        }
    }

    public static function enviarInformacionTinacos($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';

            // Texto mejorado para el mensaje sobre los tinacos
            $texto = "🛢️ *¿Necesitas un tinaco?*\n\n" .
                "¡Es muy fácil! Solo acude a nuestras *oficinas generales* y presenta los siguientes documentos: \n\n" .
                "📄 *Requisitos:*\n" .
                "• 🧾 *Recibo de agua a nombre del titular*\n" .
                "• 🪪 *Identificación oficial*\n\n" .
                "Nuestro equipo estará encantado de atenderte y ayudarte con el proceso. Si tienes alguna pregunta, no dudes en contactarnos. 😊";

            // Enviar el mensaje a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, [
                        "messaging_product" => "whatsapp",
                        "recipient_type" => "individual",
                        "to" => $sendPhoneNumber,
                        "type" => "text",
                        "text" => [
                            "body" => $texto
                        ]
                    ]);

            $statusCode = $response->status();
            $content = json_decode($response->body(), true);
            $message = new Message();
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $texto); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = "";
            $message->buttons = "";
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error(json_encode($e));
        }
    }
    public static function enviarDescuentos($id_contact)
    {
        try {
            $whatsappPhoneId = Config::where('key', '=', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', '=', 'whatsapp_permanent_access_token')->get()->first()->value;
            $sendPhoneNumber = Contact::where('id', $id_contact)->get()->first()->phone;
            $url = "https://graph.facebook.com/v21.0/" . $whatsappPhoneId . "/messages"; // endpoint actualizado


            // Mensaje interactivo con botones
            $mensaje_interactivo = [
                "messaging_product" => "whatsapp",
                "recipient_type" => "individual",
                "to" => $sendPhoneNumber,
                "type" => "interactive",
                "interactive" => [
                    "type" => "button",
                    "header" => [
                        "type" => "text",
                        "text" => "💰 ¿Buscas descuentos para saldar tu adeudo?"
                    ],
                    "body" => [
                        "text" => "Sabemos que cada situación es única. Te invitamos a visitarnos para encontrar la mejor solución. 😊\n\nHaz clic en una de las opciones para ver la ubicación más cercana:"
                    ],
                    "action" => [
                        "buttons" => [
                            [
                                "type" => "reply",
                                "reply" => [
                                    "id" => "ubicacion_oficinas",
                                    "title" => "📍 Oficinas Generales"
                                ]
                            ],
                            [
                                "type" => "reply",
                                "reply" => [
                                    "id" => "ubicacion_sucursal",
                                    "title" => "📍 Sucursal"
                                ]
                            ]
                        ]
                    ]
                ]
            ];


            // Enviar el mensaje interactivo a través de la API de WhatsApp
            $response = Http::withHeaders([
                'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                'Content-Type' => 'application/json',
            ])->post($url, $mensaje_interactivo);

            // Revisar la respuesta de la API
            $statusCode = $response->status();
            \Log::debug('Status Code: ' . $statusCode);
            $content = json_decode($response->body(), true);

            // Log para la respuesta
            \Log::debug('API Response: ' . json_encode($content));

            $message = new Message();

            // Verificar si el mensaje fue enviado correctamente
            if (isset($content['messages'])) {
                $message->fb_message_id = $content['messages'][0]['id'];
                $message->error = "";
            } else {
                $message->error = isset($content['error']) ? $content['error']['message'] : "Unknown error";
            }

            // Guardar el mensaje en la base de datos
            $clean_message = str_replace("\n", ' ', $mensaje_interactivo['interactive']['body']['text']); // Limpiar saltos de línea para almacenamiento
            $message->created_at = now();
            $message->contact_id = $id_contact;
            $message->components = json_encode($mensaje_interactivo['interactive']); // Guardar los detalles del mensaje
            $message->buttons = json_encode($mensaje_interactivo['interactive']['action']['buttons']);
            $message->status = 1;
            $message->value = $clean_message;
            $message->save();

            return $message;

        } catch (\Exception $e) {
            \Log::error("=============== Error ==============");
            \Log::error("Exception: " . $e->getMessage());
            \Log::error(json_encode($e));
        }
    }
    public static function verifyProcessPendingJMAS()
    {
        try {
            $whatsappPhoneId = Config::where('key', 'whatsapp_phone_number_id')->get()->first()->value;
            $whatsappPermanentAccesToken = Config::where('key', 'whatsapp_permanent_access_token')->get()->first()->value;
            $url = Whatsapp::$facebookAPI . $whatsappPhoneId . '/messages';
            $contactos = Contact::whereNotNull('proceso_realizando')
                ->where('updated_at', '<=', Carbon::now()->subMinutes(5))
                ->get();

            $buttons = [
                // [
                //     "type" => "reply",
                //     "reply" => [
                //         "id" => "CONTINUAR_PROCESO",
                //         "title" => "Continuar"
                //     ]
                // ],
                [
                    "type" => "reply",
                    "reply" => [
                        "id" => "TERMINAR_PROCESO",
                        "title" => "Cancelar proceso"
                    ]
                ],
            ];
            foreach ($contactos as $contact) {
                if ($contact->confirmacionProceso) {



                    $textBody = "¡Hola, {$contact->name}! 😊 Queremos informarte que, debido a la falta de respuesta, hemos tenido que cancelar tu proceso. 😔 No te preocupes, si necesitas iniciar otro reporte o tienes alguna duda, estamos aquí para ayudarte. ¡Escríbenos cuando lo necesites, estamos a tu disposición! ✨🙌";


                    $response = Http::withHeaders([
                        'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                        'Content-Type' => 'application/json',
                    ])->post($url, [
                                "messaging_product" => "whatsapp",
                                "recipient_type" => "individual",
                                "to" => $contact->phone,
                                "type" => "text",
                                "text" => [
                                    "body" => $textBody
                                ]
                            ]);
                    $contact->proceso_realizando = null;
                    $contact->confirmacionProceso = null;
                    $contact->save();
                    $content = json_decode($response->body(), true);

                    // Manejo opcional de respuesta
                    if ($response->successful()) {
                        \Log::info("Mensaje enviado correctamente.");
                    } else {
                        \Log::error("Error al enviar el mensaje: " . json_encode($content));
                    }
                    continue;
                }
                $contact->confirmacionProceso = 1;
                $contact->update();
                $response = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $whatsappPermanentAccesToken,
                    'Content-Type' => 'application/json',
                ])->post($url, [
                            "messaging_product" => "whatsapp",
                            "recipient_type" => "individual",
                            "to" => $contact->phone,
                            "type" => "interactive",
                            "interactive" => [
                                "type" => "button",
                                "body" => [
                                    "text" => "¡Hola, {$contact->name}! 👋 Notamos que dejaste un proceso pendiente. ¿Quieres continuar con él o prefieres terminarlo?😊"

                                ],
                                "action" => [
                                    "buttons" => $buttons
                                ]
                            ]
                        ]);

                $content = json_decode($response->body(), true);

                // Manejo opcional de respuesta
                if ($response->successful()) {
                    \Log::info("Mensaje enviado correctamente.");
                } else {
                    \Log::error("Error al enviar el mensaje: " . json_encode($content));
                }
            }
        } catch (\Exception $e) {
            \Log::error($e);
        }
    }



}
