<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::group([
    'middleware' =>[ 'web','impersonate','XssSanitizer','auth'],
    'namespace' => 'Modules\Solicitudes\Http\Controllers'
], function () {
    Route::prefix('solicitudes')->group(function() {

        Route::get('/', 'Main@index')->name('solicitudes.index');
        Route::get('/send_status/{id}', 'Main@sendStatus')->name('solicitudes.sendStatus');
        Route::get('/imprimirSolicitud/{id}', 'Main@imprimirSolicitud')->name('solicitudes.imprimirSolicitud');
        Route::get('/reporte', 'Main@reporte_no_resueltas')->name('solicitudes.reporte');
        Route::get('/solicitudesExcel', 'Main@solicitudesExcel')->name('solicitudes.solicitudesExcel');
        Route::post('/guardarCambios', 'Main@guardarCambios')->name('solicitudes.guardarCambios');
        Route::get('/solicitudesPendientes', 'Main@solicitudesPendientes')->name('solicitudes.solicitudesPendientes');
        Route::get('/solicitudes/cancelar/{id}', 'Main@cancelarSolicitud')
        ->name('solicitudes.cancelarSolicitud');


    });
});
