<?php
use Modules\Reports\Http\Controllers\Main;
use Modules\Reports\Http\Controllers\ReportesController;
use Barryvdh\DomPDF\Facade as PDF;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::prefix('reports')->group(function() {
//     Route::get('/', 'ReportsController@index');
// });

Route::group([
    'middleware' => ['web', 'impersonate'],
    'namespace' => 'App\Modules\Reports\Http\Controllers'
], function () {
    Route::prefix('reports')->group(function () {
        Route::get('/', [Main::class, 'index'])->name('reports.index');
        Route::post('/conversaciones/exportar/{formato}', [ReportesController::class, 'exportarConversaciones']);
        Route::post('/encuestas/exportar/{formato}', [ReportesController::class, 'exportarEncuestas']);


    });
});
