<script>
    window.onload = function() {
        Vue.config.devtools = true;

        Vue.component('autocomplete', {
            template: `
                <div>
                    <label>Seleccione el consultor</label>
                    <input type="text" v-model="search" @input="onInput" class="form-control" placeholder="Buscar consultor...">
                    <ul v-if="filteredUsers.length" class="list-group mt-2">
                        <li v-for="user in filteredUsers" @click="selectUser(user)" class="list-group-item list-group-item-action">
                            @{{ user.name }}
                        </li>
                    </ul>
                </div>
            `,
            props: ['users'],
            data() {
                return {
                    search: '',
                    filteredUsers: []
                };
            },
            methods: {
                onInput() {
                    if (this.search.length > 0) {
                        this.filteredUsers = this.users.filter(user => user.name.toLowerCase().includes(this
                            .search.toLowerCase()));
                    } else {
                        this.filteredUsers = [];
                    }
                },
                selectUser(user) {
                    this.search = user.name;
                    this.$emit('user-selected', user);
                    this.filteredUsers = [];
                }
            }
        });


        Vue.component('autocomplete-campaigns', {
            template: `
        <div>
            <label>Seleccione la campaña</label>
            <input type="text" v-model="search" @input="onInput" class="form-control" placeholder="Buscar campaña...">
            <ul v-if="filteredCampaigns.length" class="list-group mt-2">
                <li v-for="campaign in filteredCampaigns" @click="selectCampaign(campaign)" class="list-group-item list-group-item-action">
                    @{{ campaign.name }}
                </li>
            </ul>
        </div>
    `,
            props: ['campaigns'],
            data() {
                return {
                    search: '',
                    filteredCampaigns: []
                };
            },
            methods: {
                onInput() {
                    if (this.search.length > 0) {
                        this.filteredCampaigns = this.campaigns.filter(campaign => campaign.name
                            .toLowerCase().includes(this.search.toLowerCase()));
                    } else {
                        this.filteredCampaigns = [];
                    }
                },
                selectCampaign(campaign) {
                    this.search = campaign.name;
                    this.$emit('campaign-selected', campaign);
                    this.filteredCampaigns = [];
                }
            }
        });


        Vue.component('autocomplete-contacts', {
            template: `
        <div>
            <label>Seleccione el contacto</label>
            <input type="text" v-model="search" @input="onInput" class="form-control" placeholder="Buscar contacto...">
            <ul v-if="filteredContacts.length" class="list-group mt-2">
                <li v-for="contact in filteredContacts" @click="selectContact(contact)" class="list-group-item list-group-item-action">
                    @{{ contact.name }}
                </li>
            </ul>
        </div>
    `,
            props: ['contacts'],
            data() {
                return {
                    search: '',
                    filteredContacts: []
                };
            },
            methods: {
                onInput() {
                    if (this.search.length > 0) {
                        this.filteredContacts = this.contacts.filter(contact => contact.name.toLowerCase()
                            .includes(this.search.toLowerCase()));
                    } else {
                        this.filteredContacts = [];
                    }
                },
                selectContact(contact) {
                    this.search = contact.name;
                    this.$emit('contact-selected', contact);
                    this.filteredContacts = [];
                }
            }
        });


        chatList = new Vue({
            el: '#app',
            data: {
                dialogs: {
                    encuestas: false,
                    campanas: false,
                    conversaciones: false
                },
                encuestaTipo: 'General',
                usuario: {
                    id: '',
                    name: ''
                },
                campana: {
                    id: '',
                    name: ''
                },
                conversacion: {
                    id: '',
                    name: ''
                },
                fechaInicio: '',
                fechaFin: '',
                consultores: @json($consultores),
                campaigns: @json($campaigns),
                contacts: @json($contacts),
                errors: []
            },
            methods: {
                openDialog(dialog) {
                    this.errors = []
                    this.dialogs[dialog] = true;
                },
                closeDialog(dialog) {
                    this.dialogs[dialog] = false;
                },
                exportar(formato, dialog) {
                    this.errors = [];

                    const today = new Date();
                    today.setHours(0, 0, 0, 0);

                    if (dialog === 'encuestas') {
                        if (!this.encuestaTipo) {
                            this.errors.push('Debe seleccionar un tipo de encuesta.');
                        }
                        if (this.encuestaTipo === 'Por Usuario' && !this.usuario.id) {
                            this.errors.push('Debe seleccionar un usuario.');
                        }
                        if(!(this.encuestaTipo === 'Por Usuario')){
                            this.usuario.id = "";
                            this.usuario.name = "";
                        }
                    }

                    if (dialog === 'conversaciones') {
                        if (!this.usuario.id) {
                            this.errors.push('Debe seleccionar un consultor.');
                        }
                        if (!this.conversacion.id) {
                            this.errors.push('Debe seleccionar un contacto.');
                        }
                    }

                    if (dialog === 'campanas') {
                        if (!this.campana.id) {
                            this.errors.push('Selecciona una campaña');
                        }
                    } else {
                        if (!this.fechaInicio) {
                            this.errors.push('Debe seleccionar una fecha de inicio.');
                        } else if (new Date(this.fechaInicio) > today) {
                            this.errors.push('La fecha de inicio no puede ser mayor al día de hoy.');
                        }
                        if (!this.fechaFin) {
                            this.errors.push('Debe seleccionar una fecha de fin.');
                        } else if (new Date(this.fechaFin) > today) {
                            this.errors.push('La fecha de fin no puede ser mayor al día de hoy.');
                        }
                        if (this.fechaInicio && this.fechaFin && new Date(this.fechaFin) < new Date(this
                                .fechaInicio)) {
                            this.errors.push('La fecha de fin debe ser mayor a la fecha de inicio.');
                        }
                    }

                    if (this.errors.length === 0) {
                        if (dialog === 'conversaciones') {
                            axios.post(`/reports/conversaciones/exportar/${formato}`, {
                                    usuario_id: this.usuario.id,
                                    contacto_id: this.conversacion.id,
                                    fecha_inicio: this.fechaInicio,
                                    fecha_fin: this.fechaFin
                                }, {
                                    responseType: 'blob'
                                })
                                .then(response => {
                                    const url = window.URL.createObjectURL(new Blob([response.data]));
                                    const link = document.createElement('a');
                                    link.href = url;
                                    link.setAttribute('download',
                                        `conversaciones.${formato === 'excel' ? 'xlsx' : 'pdf'}`);
                                    document.body.appendChild(link);
                                    link.click();
                                    document.body.removeChild(link);
                                })
                                .catch(error => {
                                    console.error("Hubo un error al exportar el reporte:", error);
                                });
                        }
                        if (dialog === 'campanas') {
                            axios.get(`/campaigns/report/${this.campana.id}/${formato}`, {
                                    responseType: 'blob'
                                })
                                .then(response => {
                                    const url = window.URL.createObjectURL(new Blob([response.data]));
                                    const link = document.createElement('a');
                                    link.href = url;
                                    link.setAttribute('download',
                                        `${this.campana.name}.${formato === 'excel' ? 'csv' : 'pdf'}`);
                                    document.body.appendChild(link);
                                    link.click();
                                    document.body.removeChild(link);
                                })
                                .catch(error => {
                                    console.error("Hubo un error al exportar el reporte:", error);
                                });
                        }
                        if (dialog === 'encuestas') {
                            axios.post(`/reports/encuestas/exportar/${formato}`, {
                                    usuario_id: this.usuario.id ? this.usuario.id : null,
                                    contacto_id: this.conversacion.id,
                                    fecha_inicio: this.fechaInicio,
                                    fecha_fin: this.fechaFin
                                }, {
                                    responseType: 'blob'
                                })
                                .then(response => {
                                    const url = window.URL.createObjectURL(new Blob([response.data]));
                                    const link = document.createElement('a');
                                    link.href = url;
                                    link.setAttribute('download',
                                        `encuestas.${formato === 'excel' ? 'xlsx' : 'pdf'}`);
                                    document.body.appendChild(link);
                                    link.click();
                                    document.body.removeChild(link);
                                })
                                .catch(error => {
                                    console.error("Hubo un error al exportar el reporte:", error);
                                });
                        }
                    }
                },
                userSelected(user) {
                    this.usuario = {
                        id: user.id,
                        name: user.name
                    };
                },
                campaignSelected(campaign) {
                    this.campana = {
                        id: campaign.id,
                        name: campaign.name
                    };
                },
                contactSelected(contact) {
                    this.conversacion = {
                        id: contact.id,
                        name: contact.name
                    };
                }
            }
        });
    };
</script>
