@extends('layouts.app', ['title' => __('Reports')])

<!-- Incluye Vue.js -->

@section('content')
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.12/dist/vue.js"></script>
    <!-- Incluye Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    @include('reports::layouts.scripts')
    <style>
        .modal-content {
            max-height: 80vh;
            overflow-y: auto;
        }
    </style>
    <div class="container py-8" id="app">
        <div class="text-center mx-8" style>
            <h1 class="display-4 font-weight-bold text-black">Reports</h1>
        </div>
        <div class="d-flex justify-content-around my-4">
            <button @click="openDialog('encuestas')" class="btn btn-primary btn-lg">{{ __('Surveys') }}</button>
            <button @click="openDialog('campanas')" class="btn btn-primary btn-lg">{{ __('Campaigns') }}</button>
            <button @click="openDialog('conversaciones')" class="btn btn-primary btn-lg">{{ __('Conversations') }}</button>
        </div>

        <!-- Dialogo Encuestas -->
        <div v-if="dialogs.encuestas" class="modal fade show d-block" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title">{{ __('Surveys') }}</h3>
                        <button type="button" class="close" @click="closeDialog('encuestas')" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div v-if="errors.length" class="alert alert-danger">
                            <ul>
                                <li v-for="error in errors" :key="error">@{{ error }}</li>
                            </ul>
                        </div>
                        <div class="form-group">
                            <label>Seleccione Tipo</label>
                            <select v-model="encuestaTipo" class="form-control">
                                <option value="Por Usuario">{{ __('Per user') }}</option>
                                <option value="General">General</option>
                            </select>
                        </div>
                        <div v-if="encuestaTipo === 'Por Usuario'" class="form-group">
                            <autocomplete :users="consultores" @user-selected="userSelected"></autocomplete>
                        </div>
                        <div class="form-group">
                            <label>{{ __('Start date') }}</label>
                            <input type="date" v-model="fechaInicio" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>{{ __('End date') }}</label>
                            <input type="date" v-model="fechaFin" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button @click="exportar('excel', 'encuestas')" class="btn btn-success">Excel</button>
                        <button @click="exportar('pdf', 'encuestas')" class="btn btn-danger">PDF</button>
                        <button type="button" class="btn btn-secondary"
                            @click="closeDialog('encuestas')">{{ __('Close') }}</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Dialogo Campañas -->
        <div v-if="dialogs.campanas" class="modal fade show d-block" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title">{{ __('Campaigns') }}</h3>
                        <button type="button" class="close" @click="closeDialog('campanas')" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div v-if="errors.length" class="alert alert-danger">
                            <ul>
                                <li v-for="error in errors" :key="error">@{{ error }}</li>
                            </ul>
                        </div>
                        <div class="form-group">
                            <autocomplete-campaigns :campaigns="campaigns"
                                @campaign-selected="campaignSelected"></autocomplete-campaigns>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button @click="exportar('excel', 'campanas')" class="btn btn-success">Excel</button>
                        <button @click="exportar('pdf', 'campanas')" class="btn btn-danger">PDF</button>
                        <button type="button" class="btn btn-secondary"
                            @click="closeDialog('campanas')">{{ __('Close') }}</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Dialogo Conversaciones -->
        <div v-if="dialogs.conversaciones" class="modal fade show d-block" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Conversaciones</h5>
                        <button type="button" class="close" @click="closeDialog('conversaciones')" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div v-if="errors.length" class="alert alert-danger">
                            <ul>
                                <li v-for="error in errors" :key="error">@{{ error }}</li>
                            </ul>
                        </div>
                        <div class="form-group">
                            <autocomplete :users="consultores" @user-selected="userSelected"></autocomplete>
                        </div>
                        <div class="form-group">
                            <autocomplete-contacts :contacts="contacts"
                                @contact-selected="contactSelected"></autocomplete-contacts>
                        </div>
                        <div class="form-group">
                            <label>{{ __('Start date') }}</label>
                            <input type="date" v-model="fechaInicio" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>{{ __('End date') }}</label>
                            <input type="date" v-model="fechaFin" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button @click="exportar('excel', 'conversaciones')" class="btn btn-success">Excel</button>
                        <button @click="exportar('pdf', 'conversaciones')" class="btn btn-danger">PDF</button>
                        <button type="button" class="btn btn-secondary"
                            @click="closeDialog('conversaciones')">{{ __('Close') }}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
