<?php

namespace Modules\Reports\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\RespuestaEncuesta;
use App\Models\User;
use App\Models\RegistroConversacion;
use Modules\Contacts\Models\Contact;
use Illuminate\Http\Request;

class ReportesController extends Controller
{
    public function exportarConversaciones(Request $request, $formato)
    {
        $consultor = User::find($request->usuario_id);
        $contacto = Contact::find($request->contacto_id);
        $fecha_inicio = date('Y-m-d 00:00:00', strtotime($request->fecha_inicio));
        $fecha_fin = date('Y-m-d 23:59:59', strtotime($request->fecha_fin));

        // Obtener todas las conversaciones del consultor con el contacto en el rango de fechas
        $conversaciones = RegistroConversacion::where('id_user', $request->usuario_id)
            ->where('id_contacto', $request->contacto_id)
            ->where(function ($query) use ($fecha_inicio, $fecha_fin) {
                $query->whereBetween('create_at', [$fecha_inicio, $fecha_fin])
                    ->orWhereBetween('finish_at', [$fecha_inicio, $fecha_fin])
                    ->orWhere(function ($query) use ($fecha_inicio, $fecha_fin) {
                        $query->where('create_at', '<=', $fecha_inicio)
                            ->where('finish_at', '>=', $fecha_fin);
                    });
            })
            ->get();

        // Filtrar mensajes dentro del rango de fechas especificado para cada conversación
        foreach ($conversaciones as $conversacion) {
            $conversacion->messages = $conversacion->messages()
                ->whereBetween('created_at', [$conversacion->create_at, $conversacion->finish_at])
                ->get();
        }

        if ($formato === 'excel') {
            return HelpersReportesController::exportarConversacionesExcel($consultor, $contacto, $conversaciones);
        } elseif ($formato === 'pdf') {
            return HelpersReportesController::exportarConversacionesPDF($consultor, $contacto, $conversaciones);
        }
    }
    public function exportarEncuestas(Request $request, $formato)
    {
        $consultor = $request->usuario_id ? User::find($request->usuario_id) : null;
        $fechaInicio = $request->fecha_inicio;
        $fechaFin = $request->fecha_fin;

        if (!$consultor) {
            $encuestas = RespuestaEncuesta::whereDate('created_at', '>=', $fechaInicio)
                ->whereDate('created_at', '<=', $fechaFin)
                ->whereNull('id_campaing')
                ->whereNotNull('respuesta_encuesta')
                ->get();
        } else {
            $encuestas = RespuestaEncuesta::whereDate('created_at', '>=', $fechaInicio)
                ->whereDate('created_at', '<=', $fechaFin)
                ->where('id_usuario', $request->usuario_id)
                ->whereNotNull('respuesta_encuesta')
                ->get();
        }

        $questionResponsesCount  = [];

        $questions = [
            'screen_0_RadioButtonsGroup_0' => 'Resolviste tu problema',
            'screen_1_question2RadioButtons_0' => 'El tiempo de respuesta fue adecuado',
            'screen_2_RadioButtonsGroup_0' => 'Califica la atencion brindada por el consultor que te atendio'
        ];

        foreach ($encuestas as $encuesta) {
            $decodedResponse = json_decode(json_decode($encuesta->respuesta_encuesta));
            foreach ($decodedResponse as $key => $value) {
                if (strpos($key, 'RadioButtons') !== false) {
                    // Verificamos si la clave está en el mapeo de preguntas
                    if (isset($questions[$key])) {
                        $question = $questions[$key];
                        if (!isset($questionResponsesCount[$question][$value])) {
                            $questionResponsesCount[$question][$value] = 0;
                        }
                        $questionResponsesCount[$question][$value]++;
                    }
                }
            }
        }

        if ($formato === 'excel') {
            return HelpersReportesController::exportarEncuestasExcel($consultor, $encuestas, $fechaInicio, $fechaFin, $questionResponsesCount );
        } elseif ($formato === 'pdf') {
            return HelpersReportesController::exportarEncuestasPDF($consultor, $encuestas, $fechaInicio, $fechaFin, $questionResponsesCount );
        }
    }

}
