<?php

namespace Modules\Reports\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Campaign;

class Main extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $consultores = \DB::select("
            SELECT u.id, u.name, u.descripcion
            FROM users u
            JOIN model_has_roles mhr ON mhr.model_id = u.id
            JOIN users_permissions_staffs ups ON ups.user_id = u.id
            WHERE mhr.role_id = 4
        ");
        $campaigns = Campaign::all();
        $contacts = Contact::all();
        return view('reports::index', [
            'consultores' => $consultores,
            'campaigns' => $campaigns,
            'contacts' => $contacts
        ]);
    }


    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        return view('reports::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Response
     */
    public function show($id)
    {
        return view('reports::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Response
     */
    public function edit($id)
    {
        return view('reports::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Response
     */
    public function destroy($id)
    {
        //
    }
}
