<?php

namespace Modules\Reports\Http\Controllers;

use App\Exports\ConversacionesExport;
use App\Exports\EncuestasExport;
use App\Http\Controllers\Controller;
use App\Models\RespuestaEncuesta;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;
use Modules\Wpbox\Models\Campaign;

class HelpersReportesController extends Controller
{

    public static function exportarConversacionesExcel($consultor, $contacto, $conversaciones)
    {
        $data = [
            'consultor' => $consultor,
            'contacto' => $contacto,
            'conversaciones' => $conversaciones
        ];

        return Excel::download(new ConversacionesExport($data), 'conversaciones.xlsx');
    }

    public static function exportarConversacionesPDF($consultor, $contacto, $conversaciones)
    {
        $data = [
            'consultor' => $consultor,
            'contacto' => $contacto,
            'conversaciones' => $conversaciones
        ];

        $pdf = Pdf::loadView('reportes.conversaciones_pdf', $data);
        $pdf->setOption([
            "defaultPaperSize" => "letter",
            'isHtml5ParserEnabled' => true,
            "defaultFont" => "tahoma"
        ]);
        return $pdf->download('conversaciones.pdf');
    }

    public static function exportToExcelCampaign(Campaign $campaign)
    {
        $filename = storage_path("app/report_campaign_" . $campaign->name . "_" . now()->format('Y-m-d_H-i-s') . ".csv");
        $handle = fopen($filename, 'w+');

        // Contar el total de mensajes
        $totalMessages = $campaign->messages->count();

        // Contar las respuestas de tipo botón de radio
        $radioResponsesCount = [];

        foreach ($campaign->messages as $message) {
            $respuesta = RespuestaEncuesta::where('id_campaing', $campaign->id)
                ->where('id_contacto', $message->contact->id)
                ->first();

            if ($respuesta) {
                $decodedResponse = json_decode(json_decode($respuesta->respuesta_encuesta));
                foreach ($decodedResponse as $key => $value) {
                    if (strpos($key, 'RadioButtonsGroup') !== false) {
                        if (!isset($radioResponsesCount[$value])) {
                            $radioResponsesCount[$value] = 0;
                        }
                        $radioResponsesCount[$value]++;
                    }
                }
            }
        }

        // Escribir el encabezado y la cantidad de mensajes
        fputcsv($handle, ["Total Messages", $totalMessages]);
        fputcsv($handle, []); // Línea en blanco

        // Escribir los resultados de las respuestas de tipo botón de radio
        foreach ($radioResponsesCount as $response => $count) {
            fputcsv($handle, ["Respuesta", $response, "Conteo", $count]);
        }
        fputcsv($handle, []); // Línea en blanco

        // Encabezado de la tabla principal
        fputcsv($handle, ['Name', 'Phone', 'Country', 'Status', 'Sent at', 'Respuesta']);

        foreach ($campaign->messages as $message) {
            // Status
            $status = static::getStatus($message->status);

            // Respuesta
            $respuesta = RespuestaEncuesta::where('id_campaing', $campaign->id)
                ->where('id_contacto', $message->contact->id)
                ->first();
            $respuestaTexto = $respuesta ? static::formatSurveyResponse($respuesta->respuesta_encuesta) : '';

            fputcsv(
                $handle,
                array(
                    $message->contact->name,
                    $message->contact->phone,
                    $message->contact->country->name,
                    $status,
                    $message->scchuduled_at ? $message->scchuduled_at : $message->created_at,
                    $respuestaTexto
                )
            );
        }

        fclose($handle);

        $headers = array(
            'Content-Type' => 'text/csv',
        );

        return response()->download($filename, basename($filename), $headers)->deleteFileAfterSend(true);
    }

    public static function exportToPdfCampaign(Campaign $campaign)
    {
        // Contar el total de mensajes
        $totalMessages = $campaign->messages->count();

        // Contar las respuestas de tipo botón de radio
        $radioResponsesCount = [];

        // foreach ($campaign->messages as $message) {
        //     $respuesta = RespuestaEncuesta::where('id_campaing', $campaign->id)
        //         ->where('id_contacto', $message->contact->id)
        //         ->first();

        //     if ($respuesta) {
        //         $decodedResponse = json_decode(json_decode($respuesta->respuesta_encuesta));
        //         if (gettype($decodedResponse) == 'object') {
        //             foreach ($decodedResponse as $key => $value) {
        //                 if (strpos($key, 'RadioButtonsGroup') !== false) {
        //                     if (!isset($radioResponsesCount[$value])) {
        //                         $radioResponsesCount[$value] = 0;
        //                     }
        //                     $radioResponsesCount[$value]++;
        //                 }
        //             }
        //         }
        //     }
        // }

        // Datos para la vista del PDF
        $data = [
            'campaign' => $campaign,
            'totalMessages' => $totalMessages,
            'radioResponsesCount' => $radioResponsesCount,
            'messages' => $campaign->messages->map(function ($message) use ($campaign) {
                $respuesta = RespuestaEncuesta::where('id_campaing', $campaign->id)
                    ->where('id_contacto', $message->contact->id)
                    ->first();
                // $respuestaTexto = $respuesta ? static::formatSurveyResponse($respuesta->respuesta_encuesta) : $respuesta->respuesta_encuesta;
                $respuestaTexto = $respuesta ? $respuesta->respuesta_encuesta : '';
                return [
                    'name' => $message->contact->name,
                    'phone' => $message->contact->phone,
                    'country' => $message->contact->country->name,
                    'status' => static::getStatus($message->status),
                    'sent_at' => $message->scchuduled_at ? $message->scchuduled_at : $message->created_at,
                    'respuesta' => $respuestaTexto,
                ];
            })
        ];

        $pdf = Pdf::loadView('reportes.campaign_pdf', $data);
        $pdf->setOption([
            "defaultPaperSize" => "letter",
            'isHtml5ParserEnabled' => true,
            "defaultFont" => "tahoma"
        ]);

        $filename = "report_campaign_" . $campaign->name . "_" . now()->format('Y-m-d_H-i-s') . ".pdf";
        return $pdf->download($filename);
    }


    public static function getStatus($status)
    {
        switch ($status) {
            case 0:
                return "PENDING_SENT";
            case 1:
                return "SENT_ERROR";
            case 2:
                return "SENT";
            case 3:
                return "DELIVERED";
            case 4:
                return "READ";
            case 5:
                return "FAILED";
            default:
                return "UNKNOWN";
        }
    }
    public static function formatSurveyResponse($jsonResponse)
    {
        // Decodificar la respuesta JSON a un array asociativo
        $data = json_decode($jsonResponse);
        $data = json_decode($data);

        $formattedResponse = [];

        // Mapeo de claves a nombres más descriptivos
        $keyMapping = [
            "RadioButtonsGroup" => "Calificación",
            "TextArea" => "Comentario"
        ];

        // Iterar sobre cada elemento del array
        if (gettype($data) == 'object') {
            foreach ($data as $key => $value) {
                if ($key === "flow_token") {
                    continue; // Omitir el flow_token
                }

                foreach ($keyMapping as $partialKey => $descriptiveName) {
                    if (strpos($key, $partialKey) !== false) {
                        // Procesar el valor para hacerlo más legible
                        $formattedValue = static::processSurveyValue($partialKey, $value);
                        $formattedResponse[$descriptiveName] = $formattedValue;
                        break;
                    }
                }
            }
        }

        $responseString = "";
        foreach ($formattedResponse as $key => $value) {
            $responseString .= "$key: $value\n";
        }

        return $responseString;
    }

    private static function processSurveyValue($key, $value)
    {
        if ($key === "RadioButtonsGroup") {
            // Ejemplo de procesamiento para RadioButtonsGroup
            $parts = explode('_', $value);
            if (count($parts) > 1) {
                // Tomar la parte que tiene la calificación y la descripción
                return end($parts);
            }
        }
        // Otros posibles procesamientos para otros tipos de entrada
        return $value;
    }

    public static function exportarEncuestasExcel($consultor, $encuestas, $fechaInicio, $fechaFin, $radioResponsesCount)
    {
        $data = [
            'consultor' => $consultor,
            'encuestas' => $encuestas,
            'fechaInicio' => $fechaInicio,
            'fechaFin' => $fechaFin,
            'radioResponsesCount' => $radioResponsesCount
        ];

        return Excel::download(new EncuestasExport($data), 'encuestas.xlsx');
    }

    public static function exportarEncuestasPDF($consultor, $encuestas, $fechaInicio, $fechaFin, $radioResponsesCount)
    {
        $data = [
            'consultor' => $consultor,
            'encuestas' => $encuestas,
            'fechaInicio' => $fechaInicio,
            'fechaFin' => $fechaFin,
            'radioResponsesCount' => $radioResponsesCount
        ];

        $pdf = Pdf::loadView('reportes.encuestas_pdf', $data);
        $pdf->setOption([
            "defaultPaperSize" => "letter",
            'isHtml5ParserEnabled' => true,
            "defaultFont" => "tahoma"
        ]);
        return $pdf->download('encuestas.pdf');
    }
}
