<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::group([
    'middleware' => ['web', 'impersonate', 'XssSanitizer', 'auth'],
    'namespace' => 'Modules\ReportesBot\Http\Controllers'
], function () {
    Route::prefix('reportes_bot')->group(function () {

        Route::get('/', 'Main@index')->name('reportesbot.index');
        Route::get('/send_status/{id}', 'Main@sendStatus')->name('reportesbot.sendStatus');
        Route::get('/reporte', 'Main@reporte_no_resueltas')->name('reportesbot.reporte');
        Route::get('/reportePendientes', 'Main@reportePendientes')->name('reportesbot.reportePendientes');
        Route::post('/guardarCambios', 'Main@guardarCambios')->name('reportesbot.guardarCambios');
        Route::get('/imprimirReporte/{id}', 'Main@imprimirReporte')->name('reportesbot.imprimirReporte');
        Route::get('/reporteExcel', 'Main@reporteExcel')->name('reportesbot.reporteExcel');
        Route::get('/reportes/cancelar/{id}', 'Main@cancelarReporte')
        ->name('reportesbot.cancelarReporte');


    });
});
