@extends('general.index', $setup)

@section('thead')
    <div class="row mb-4">
        <!-- Botón para descargar reportes no resueltos -->
        <div class="col-md-4 text-center">
            <a href="{{ route('reportesbot.reporte') }}" class="btn btn-warning">
                <i class="fas fa-download"></i> {{ __('Descargar no resueltos') }}
            </a>
        </div>
        <div class="col-md-4 text-center">
            <a href="{{ route('reportesbot.reportePendientes') }}" class="btn btn-success">
                <i class="fas fa-download"></i> {{ __('Descargar pendientes') }}
            </a>
        </div>
        <div class="col-md-4 text-center">
            <a href="#" onclick="exportarExcel()" class="btn btn-primary">
                <i class="fas fa-file-excel"></i> {{ __('Descargar todos en excel') }}
            </a>
        </div>

        <script>
            function exportarExcel() {
                let queryString = window.location.search; // Toma los filtros de la URL
                console.log("Filtros tomados de la URL:", queryString); // Depuración

                window.location.href = "{{ route('reportesbot.reporteExcel') }}" + queryString;
            }
        </script>


    </div>
    <!-- Formulario de búsqueda -->
    <div class="row mb-4">
        <div class="col-md-12">
            <form method="GET" action="{{ route('reportesbot.index') }}" class="d-flex flex-wrap gap-2">

                <input type="text" name="folio" class="form-control" placeholder="Folio"
                    value="{{ request('folio') }}">
                <input type="text" name="tipo_reporte" class="form-control" placeholder="Tipo de reporte"
                    value="{{ request('tipo_reporte') }}">
                <input type="text" name="nombre_contacto" class="form-control" placeholder="Nombre del contacto"
                    value="{{ request('nombre_contacto') }}">
                <input type="text" name="ubicacion" class="form-control" placeholder="Ubicación"
                    value="{{ request('ubicacion') }}">
                Fecha de inicio
                <input type="date" name="fecha_inicio" class="form-control" placeholder="Fecha inicio"
                    value="{{ request('fecha_inicio') }}">
                Fecha de fin
                <input type="date" name="fecha_fin" class="form-control" placeholder="Fecha fin"
                    value="{{ request('fecha_fin') }}">

                <select name="estatus" class="form-select">
                    <option value="">{{ __('Todos los estatus') }}</option>
                    <option value="PENDIENTE" {{ request('estatus') == 'PENDIENTE' ? 'selected' : '' }}>Pendiente</option>
                    <option value="PROCESADO" {{ request('estatus') == 'PROCESADO' ? 'selected' : '' }}>Procesado</option>
                    <option value="NO_SE_RESOLVIO" {{ request('estatus') == 'NO_SE_RESOLVIO ' ? 'selected' : '' }}>No se
                        resolvio</option>
                    <option value="RESUELTO" {{ request('estatus') == 'RESUELTO' ? 'selected' : '' }}>Resuelto</option>
                    <option value="CANCELADO" {{ request('estatus') == 'CANCELADO' ? 'selected' : '' }}>Cancelado</option>
                </select>
                <select name="estatusOpciones" class="form-select">
                    <option value="">{{ __('Todas las opciones de estatus') }}</option>
                    <option value="1" {{ request('estatusOpciones') == '1' ? 'selected' : '' }}>Creado</option>
                    <option value="2" {{ request('estatusOpciones') == '2' ? 'selected' : '' }}>Capturado</option>
                    <option value="3" {{ request('estatusOpciones') == '3' ? 'selected' : '' }}>En ejecución</option>
                    <option value="4" {{ request('estatusOpciones') == '4' ? 'selected' : '' }}>Terminado</option>
                    <option value="5" {{ request('estatusOpciones') == '5' ? 'selected' : '' }}>Crítico</option>
                </select>
                <select name="per_page" class="form-select" onchange="this.form.submit()">
                    <option value="10" {{ request('per_page') == 10 ? 'selected' : '' }}>10 por página</option>
                    <option value="20" {{ request('per_page') == 20 ? 'selected' : '' }}>20 por página</option>
                    <option value="50" {{ request('per_page') == 50 ? 'selected' : '' }}>50 por página</option>
                    <option value="100" {{ request('per_page') == 100 ? 'selected' : '' }}>100 por página</option>
                </select>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-search"></i> {{ __('Buscar') }}
                </button>
                @if (request()->anyFilled([
                        'folio',
                        'tipo_reporte',
                        'nombre_contacto',
                        'ubicacion',
                        'estatus',
                        'fecha_inicio',
                        'fecha_fin',
                    ]))
                    <a href="{{ route('reportesbot.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-times"></i> {{ __('Limpiar') }}
                    </a>
                @endif

            </form>
        </div>
    </div>

    <table class="table table-hover table-striped align-middle">
        <thead class="table-dark">
            <tr>
                <th>{{ __('Folio') }}</th>
                <th>{{ __('Tipo de reporte') }}</th>
                <th>{{ __('Estatus') }}</th>
                <th>{{ __('Estatus opciones') }}</th>
                <th>{{ __('Acciones') }}</th>
                <th>{{ __('Nombre o numero de servicio') }}</th>
                <th>{{ __('Contacto') }}</th>
                <th>{{ __('Descripción') }}</th>
                <th>{{ __('Ubicación') }}</th>
                <th>{{ __('Imagen') }}</th>
                <th>{{ __('Contexto') }}</th>
                <th>{{ __('Creada el') }}</th>
            </tr>
        </thead>
    @endsection

    @section('tbody')
        <tbody>
            @if ($setup['items'][0][0] && $setup['items'][0][0]->id == 0)
                <tr>
                    <td>
                        No se encontraron registros
                    </td>
                </tr>
            @else
                @forelse ($setup['items'] as $item)
                    <tr>
                        <td><span class="badge bg-info">{{ $item->folio }}</span></td>
                        <td>{{ $item->tipo_reporte }}</td>
                        <td>
                            <span
                                class="badge
                        @if ($item->estatus === 'PENDIENTE') bg-warning
                        @elseif($item->estatus === 'PROCESADO') bg-success
                        @elseif($item->estatus === 'NO_SE_RESOLVIO') bg-red
                        @else bg-secondary @endif">
                                {{ $item->estatus }}
                            </span>
                        </td>
                        <td>
                            @php
                                $estatus = [
                                    1 => 'Creado',
                                    2 => 'Capturado',
                                    3 => 'En ejecución',
                                    4 => 'Terminado',
                                    5 => 'Crítico',
                                ];
                            @endphp
                            <select class="form-select cambio-select" data-id="{{ $item->id }}">
                                @foreach ($estatus as $key => $label)
                                    @if ($key >= $item->estatusOpciones)
                                        <option value="{{ $key }}"
                                            {{ $item->estatusOpciones == $key ? 'selected' : '' }}>{{ $label }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                        </td>
                        <td>
                            @if ($item->estatus == 'PENDIENTE')
                                <a href="{{ route('reportesbot.sendStatus', ['id' => $item->id]) }}"
                                    class="btn btn-success btn-sm" title="{{ __('Marcar como procesado') }}">
                                    <i class="ni ni-check-bold"></i>
                                </a>
                            @endif
                            @if ($item->estatus == 'NO_SE_RESOLVIO')
                                <a href="{{ route('reportesbot.sendStatus', ['id' => $item->id]) }}"
                                    class="btn btn-success btn-sm" title="{{ __('Marcar como resuelto') }}">
                                    <i class="ni ni-check-bold"></i>
                                </a>
                            @endif
                            <a href="{{ route('reportesbot.imprimirReporte', ['id' => $item->id]) }}"
                                class="btn btn-success btn-sm" title="{{ __('Imprimir reporte') }}">
                                <i class="ni ni-single-copy-04"></i>
                            </a>
                            @if ($item->estatus != 'RESUELTO' && $item->estatus != 'CANCELADO')
                                <a href="{{ route('reportesbot.cancelarReporte', ['id' => $item->id]) }}"
                                    class="btn btn-danger btn-sm" title="{{ __('Cancelar reporte') }}">
                                    <i class="ni ni-fat-remove"></i> {{ __('Cancelar') }}
                                </a>
                            @endif
                        </td>

                        <td>{{ $item->nombre_o_servicio }}</td>
                        <td>
                            <a href="{{ route('chat.index', ['id_contacto' => $item->id_contacto]) }}"
                                class="badge badge-primary">
                                <i class="fas fa-user"></i> {{ $item->nombre_contacto }}
                            </a>
                        </td>
                        <td>{{ $item->descripcion_reporte ?? __('Sin descripción') }}</td>
                        <td>{{ $item->ubicacion }}</td>

                        <td>
                            @if ($item->foto_reporte)
                                <a href="{{ asset($item->foto_reporte) }}" target="_blank" download>
                                    <img src="{{ asset($item->foto_reporte) }}" alt="{{ __('Foto del reporte') }}"
                                        class="img-thumbnail" style="max-width: 100px;">
                                </a>
                            @else
                                <em>{{ __('Sin imagen') }}</em>
                            @endif
                        </td>
                        <td>
                            @if ($item->foto_context_lugar)
                                <a href="{{ asset($item->foto_context_lugar) }}" target="_blank">
                                    <img src="{{ asset($item->foto_context_lugar) }}"
                                        alt="{{ __('Foto del contexto') }}" class="img-thumbnail"
                                        style="max-width: 100px;">
                                </a>
                            @else
                                <em>{{ __('Sin contexto') }}</em>
                            @endif
                        </td>
                        <td>{{ $item->created_at->format('d/m/Y') }}</td>

                    </tr>
                @empty
                    {{-- <tr> --}}
                    <td colspan="10" class="text-center text-muted">{{ __('No se encontraron reportes.') }}</td>
                    {{-- </tr> --}}
                @endforelse
            @endif

        </tbody>
        <script>
            document.querySelectorAll('.cambio-select').forEach(select => {
                select.addEventListener('change', function() {
                    let id = this.dataset.id;
                    let opcion = this.value;

                    fetch("{{ route('reportesbot.guardarCambios') }}", {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({
                                cambios: [{
                                    id: id,
                                    opcion: opcion
                                }]
                            })
                        }).then(response => response.json())
                        .then(data => {
                            console.log('Cambio guardado:', data);
                        }).catch(error => console.error('Error:', error));
                });
            });
        </script>
    @endsection
