@extends('layouts.app')
@section('admin_title')
    {{ __('Dashboard') }}
@endsection

@section('content')
    <div class="header pb-8 pt-5 pt-md-8">
        <div class="container-fluid">
            <div class="header-body">

                <h1 class="mb-3 mt--3">{{ __('Welcome!') }}, {{ auth()->user()->name }}</h1>
                @if (count($tasks) > 0)
                    @include('dashboard::tasks')
                @endif
                @foreach (config('global.modulesWithDashboardInfo') as $moduleWithDashboardInfo)
                    @include($moduleWithDashboardInfo . '::dashboard')
                @endforeach
                @if (auth()->user()->hasRole('staff') || auth()->user()->hasRole('owner'))
                    <div class="d-flex">
                        <div class="px-5">
                            <canvas id="myChart1" class="chart" height="370" width="400"></canvas>
                        </div>
                        <div class="px-5">
                            <canvas id="myChart2" class="chart" height="370" width="400"></canvas>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="container-fluid mt--6">
        @yield('dashboard_content')
        @yield('dashboard_content2')
        @yield('dashboard_content3')
        @yield('dashboard_content4')
    </div>
@endsection
<script>
    document.addEventListener('DOMContentLoaded', function() {
        axios.get('/api/wpbox/dataForGraphs')
            .then(function(response) {
                var data = response.data;

                // Verificar si los datos son de 'consultants' o 'contacts'
                if (data.consultants) {
                    // Datos para la gráfica de consultores
                    var ctx1 = document.getElementById('myChart1').getContext('2d');
                    var myChart1 = new Chart(ctx1, {
                        type: 'bar',
                        data: {
                            labels: data.consultants,
                            datasets: [{
                                label: 'Conversaciones en el mes',
                                data: data.conversations,
                                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });

                    // Datos para la segunda gráfica de consultores
                    var ctx2 = document.getElementById('myChart2').getContext('2d');
                    var myChart2 = new Chart(ctx2, {
                        type: 'bar',
                        data: {
                            labels: data.consultants,
                            datasets: [{
                                label: 'Duracion promedio de conversaciones',
                                data: data.duration,
                                backgroundColor: 'rgba(153, 102, 255, 0.2)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });
                } else {
                    // Datos para la gráfica de contactos
                    var ctx1 = document.getElementById('myChart1').getContext('2d');
                    var myChart1 = new Chart(ctx1, {
                        type: 'bar',
                        data: {
                            labels: data.contacts,
                            datasets: [{
                                label: 'Conversaciones en el mes',
                                data: data.conversations,
                                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                                borderColor: 'rgba(75, 192, 192, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });

                    // Datos para la segunda gráfica de contactos
                    var ctx2 = document.getElementById('myChart2').getContext('2d');
                    var myChart2 = new Chart(ctx2, {
                        type: 'bar',
                        data: {
                            labels: data.contacts,
                            datasets: [{
                                label: 'Duracion promedio de conversaciones',
                                data: data.duration,
                                backgroundColor: 'rgba(153, 102, 255, 0.2)',
                                borderColor: 'rgba(153, 102, 255, 1)',
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });
                }
            })
            .catch(function(error) {
                console.error(error);
            });
    });
</script>
