@extends('layouts.app', ['title' => __("Excel contacts Import ")])

@section('content')
    <div class="header pb-8 pt-5 pt-md-8"></div>
    <div class="container-fluid mt--7" id="app">
        <div class="row">
            <div class="col">
                <div class="card shadow">
                    <div v-if="isLoading || progress > 0" class="progress mt-4" style="height: 25px;">
                        <div class="progress-bar progress-bar-striped progress-bar-animated bg-success" role="progressbar" :style="{ width: progress + '%' }" :aria-valuenow="progress" aria-valuemin="0" aria-valuemax="100">@{{ Math.floor(progress) }}%</div>
                    </div>
                    <div class="card-header border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h3 class="mb-0">{{ __("Excel contacts Import ") }}</h3>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        @include('partials.flash')
                    </div>

                    <div class="card-body d-flex justify-content-between">
                        <form @submit.prevent="handleSubmit" class="w-50" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label for="xlsx">Excel file</label>
                                <input
                                    type="file"
                                    id="xlsx"
                                    class="form-control"
                                    required
                                    accept=".xlsx"
                                    @change="handleFileUpload"
                                />
                                <small class="form-text text-muted">
                                    Headers phone, name. El celular no debe de incluir la lada y debe de tener una extensión de 10 dígitos
                                </small>
                            </div>
                            <div class="form-group">
                                <button
                                    type="submit"
                                    class="btn btn-success w-100"
                                    :disabled="isLoading"
                                >
                                    <span v-if="!isLoading">{{ __('Import contact') }}</span>
                                    <span v-if="isLoading">
                                        <span
                                            class="spinner-border spinner-border-sm"
                                            role="status"
                                            aria-hidden="true"
                                        ></span> {{ __('Loading') }}...
                                    </span>
                                </button>
                            </div>
                        </form>

                        <div class="ml-4 w-50">
                            <div v-if="importErrors.length > 0" class="mt--6">
                                <h4 class=" text-center">{{ __('Import Errors') }}</h4>
                                <div clasS="alert alert-danger">
                                    <ul class="list-unstyled">
                                        <li
                                            v-for="(error, index) in importErrors"
                                            :key="index"
                                            class="mb-2"
                                        >
                                            <strong>@{{ error.name }} (@{{ error.phone }}):</strong> @{{ error.error }}
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div v-if="successMessage" class="alert alert-success mt-3">
                                <strong>@{{ successMessage }}</strong>
                            </div>
                            <div v-if="invalidFileError" class="alert alert-danger mt-3">
                                <strong>@{{ invalidFileError }}</strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('layouts.footers.auth')
    </div>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.12/dist/vue.js"></script>
    <script>
        new Vue({
            el: '#app',
            data: {
                isLoading: false,
                importErrors: [],
                successMessage: '',
                invalidFileError: '',
                file: null,
                progress: 0,
                pollInterval: null
            },
            methods: {
                handleFileUpload(event) {
                    this.file = event.target.files[0];
                },
                async handleSubmit() {
                    if (!this.file) return;
                    this.isLoading = true;
                    this.importErrors = [];
                    this.successMessage = '';
                    this.invalidFileError = '';
                    this.progress = 0;

                    const formData = new FormData();
                    formData.append('xlsx', this.file);

                    // Mostrar barra de progreso inmediatamente
                    this.progress = 1;

                    try {
                        const response = await axios.post('{{ route('contacts.import.store') }}', formData, {
                            headers: {
                                'Content-Type': 'multipart/form-data'
                            }
                        });

                        if (response.data.errors) {
                            this.importErrors = response.data.errors;
                            this.successMessage = ''
                            this.isLoading = false;
                        } else if (response.data.status === 'success') {
                            this.successMessage = response.data.message;
                            this.pollProgress();
                        } else if (response.data.status === 'error') {
                            this.invalidFileError = response.data.message;
                            this.successMessage = ''
                            this.isLoading = false;
                        }
                    } catch (error) {
                        console.error('Error importing contacts:', error);
                        this.isLoading = false;
                    }
                },
                async pollProgress() {
                    this.pollInterval = setInterval(async () => {
                        try {
                            const response = await axios.get('{{ route('contacts.import.progress') }}');
                            this.progress = response.data.progress;

                            if (this.progress >= 100) {
                                clearInterval(this.pollInterval);
                                this.isLoading = false;
                                this.progress = 100; // Ensure the progress bar shows 100%
                                this.importErrors = response.data.errors;
                                this.successMessage = '';
                                if (this.importErrors.length === 0) {
                                    this.successMessage = '{{ __("Contacts imported successfully.") }}';
                                }
                            }
                        } catch (error) {
                            console.error('Error fetching progress:', error);
                            this.isLoading = false;
                        }
                    }, 100); // Poll every 0.1 seconds (10 times per second)
                }
            },
            beforeDestroy() {
                if (this.pollInterval) {
                    clearInterval(this.pollInterval);
                }
            }
        });
    </script>
@endsection
