<?php

namespace Modules\Contacts\Imports;

use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Modules\Contacts\Models\Contact;
use Modules\Contacts\Models\Field;

class ContactsImport implements ToModel, WithHeadingRow
{
    public function model(array $row)
    {
        // Limpiar el número de teléfono
        $phone = preg_replace('/[^0-9]/', '', $row['phone']);
        if (strlen($phone) === 10) {
            // Si son 10 dígitos, añadir 521
            $phone = '521' . $phone;
        } elseif (strlen($phone) === 13 && substr($phone, 0, 3) === '521') {
            // Si son 13 dígitos y comienza con 521, no hacer nada
        } elseif (strlen($phone) === 12 && substr($phone, 0, 2) === '52') {
            // Si son 12 dígitos y comienza con 52, reemplazar 52 con 521
            $phone = '521' . substr($phone, 2);
        } else {
            // Si no cumple ninguna de las condiciones anteriores, no crear el contacto
            return null;
        }
        // \Log::debug($phone);
        // Capitalizar el nombre
        $name = ucwords(strtolower($row['name']));

        // Verificar si el contacto ya existe
        $existingContact = Contact::where('phone', $phone)->first();
        if ($existingContact) {
            return $existingContact; // Si ya existe, devolver el contacto existente
        }

        // Crear un nuevo contacto
        $contact = new Contact([
            'name' => $name,
            'phone' => $phone,
        ]);

        // Guardar el contacto
        $contact->save();

        // Asignar avatar si existe en el archivo
        if (isset($row['avatar'])) {
            $contact->avatar = $row['avatar'];
            $contact->save();
        }

        // Procesar campos personalizados
        $keys = array_keys($row);
        foreach ($keys as $key) {
            if ($key !== 'name' && $key !== 'phone' && $key !== 'avatar') {
                $fieldID = $this->getOrMakeField($key);
                if ($fieldID !== 0 && !empty($row[$key])) {
                    $contact->fields()->attach($fieldID, ['value' => $row[$key]]);
                }
            }
        }

        return $contact;
    }

    private function getOrMakeField($fieldName)
    {
        if (in_array($fieldName, ['name', 'phone', 'avatar'])) {
            return 0;
        }

        $field = Field::where('name', $fieldName)->first();
        if (!$field) {
            $field = Field::create([
                'name' => $fieldName,
                'type' => "text",
            ]);
        }

        return $field->id;
    }
}
