<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Contacts\Models\Contact;
use Modules\Wpbox\Models\Message;

class RespuestaEncuesta extends Model
{
    use HasFactory;

    protected $table = 'respuestas_encuestas';

    protected $fillable = [
        'id_contacto',
        'id_usuario',
        'id_campaing',
        'fb_message_id_encuesta',
        'respuesta_encuesta',
        'created_at'
    ];

    // Definir la relación con el modelo Contact
    public function contacto()
    {
        return $this->belongsTo(Contact::class, 'id_contacto');
    }

    public static function guardarRespuestaEncuesta($id_contacto, $json_response)
    {
        try {
            $messageContext = Message::where('fb_message_id', $json_response['context']['id'])->first();

            // Si no hay contexto de la respuesta de esa encuesta, retornamos
            if (!$messageContext) {
                return;
            }

            // En caso de ser una respuesta a una campaña, creamos la respuesta de la campaña
            if ($messageContext->is_campign_messages) {
                $responseExist = self::where('fb_message_id_encuesta', $messageContext->fb_message_id)->first();
                if (!$responseExist) {
                    return self::create([
                        'id_contacto' => $id_contacto,
                        'id_campaing' => $messageContext->campaign_id,
                        'id_usuario' => NULL,
                        'fb_message_id_encuesta' => $messageContext->fb_message_id,
                        'respuesta_encuesta' => json_encode($json_response['interactive']['nfm_reply']['response_json']),
                        'created_at' => now(),
                    ]);
                }
            } else {
                // En caso de no ser la respuesta de una encuesta, actualizamos la respuesta de esa encuesta
                $responseSurveyByUser = self::where('fb_message_id_encuesta', $messageContext->fb_message_id)->first();
                if (!$responseSurveyByUser) {
                    return;
                }
                $responseSurveyByUser->respuesta_encuesta = json_encode($json_response['interactive']['nfm_reply']['response_json']);
                $responseSurveyByUser->save();
            }
        } catch (\Exception $e) {
            \Log::error('================Guardar Encuesta Error====================');
            \Log::error($e);
            \Log::error('================Fin Guardar Encuesta Error====================');
        }
    }
}
