<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Carbon;
use Modules\Wpbox\Models\Message;

class RegistroConversacion extends Model
{
    protected $table = 'registro_conversaciones';


    protected $fillable = [
        'id_user',
        'id_contacto',
        'create_at',
        'finish_at',
        'tiempo_conversacion',
    ];

    protected $dates = [
        'create_at',
        'finish_at',
    ];

    public function messages(): HasMany
    {
        return $this->hasMany(Message::class, 'contact_id', 'id_contacto');
    }

    // Method to calculate average conversation time
    public static function promedioConversaciones($user_id)
    {
        $minimumTime = Config::where('key', '=', 'tiempo_espera')->get()->first();
        if ($minimumTime) {
            $minimumTime = intval($minimumTime->value);
        }else{
            $minimumTime = 15;
        }

        $avgTime = self::where('id_user', $user_id)->avg('tiempo_conversacion');

        if (!$avgTime || $avgTime<$minimumTime) {

            $avgTime = $minimumTime;
        }

        $lastConversation = self::where('id_user', $user_id)
            ->whereNotNull('finish_at')
            ->orderBy('finish_at', 'desc')
            ->first();

        if ($lastConversation) {
            $lastFinishAt = Carbon::parse($lastConversation->finish_at);
            $timeSinceLastConversation = $lastFinishAt->diffInMinutes(now());


            if ($timeSinceLastConversation < $minimumTime) {
                $timeSinceLastConversation = $minimumTime;
            }
        } else {
            $timeSinceLastConversation = $minimumTime;
        }

        return (object) [
            'avgTime' => $avgTime,
            'timeSinceLastConversation' => $timeSinceLastConversation
        ];
    }

    // Method to start a new conversation
    public static function StartConversation($id_user, $id_contacto)
    {
        return self::create([
            'id_user' => $id_user,
            'id_contacto' => $id_contacto,
            'create_at' => now(),
        ]);
    }
    public static function GetConversation($id_contacto)
    {
        $conversacion = self::where('id_contacto', $id_contacto)
            ->whereNull('finish_at')
            ->first();

        if ($conversacion) {
            $createAt = Carbon::parse($conversacion->create_at);
            $currentTime = Carbon::now();
            $conversacion = $createAt->diffInSeconds($currentTime);


        } else {
            $conversacion = 0;
        }


        return $conversacion;
    }


    // Method to finish a specific conversation where finish_at is null
    public static function finishConversation($id_contacto)
    {
        $conversacion = self::where('id_contacto', $id_contacto)
            ->whereNull('finish_at')
            ->first();

        if ($conversacion) {
            $conversacion->finish_at = now();
            if ($conversacion->create_at) {
                $createAt = Carbon::parse($conversacion->create_at);
                $finishAt = Carbon::parse($conversacion->finish_at);
                $conversacion->tiempo_conversacion = $createAt->diffInMinutes($finishAt);
            }
            $conversacion->save();
        }

        return $conversacion;
    }

}
