<?php

namespace App\Http\Controllers;

use App\Models\Company;
use Illuminate\Auth\Events\Registered;
use Illuminate\Contracts\Auth\StatefulGuard;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Fortify\Contracts\CreatesNewUsers;
use App\Models\User;
use Illuminate\Support\Str;
class RegisteredUserController extends Controller
{
    public function create_new_owner(Request $request)
    {
        // Validación de los datos
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
        ]);

        // Si la validación falla, regresar con errores
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $existingUser = User::where('email', $request->email)->first();
        $cantidadUsers = count(User::where('id', '!=', 1)->get());

        if ($existingUser) {
            return redirect()->back()->withErrors(['email' => 'El correo electrónico ya está en uso.'])->withInput();
        }
        if ($cantidadUsers > 10) {
            return redirect()->back()->withErrors(['El maximo de usuarios permitidos es 10'])->withInput();
        }

        // Crear el nuevo usuario
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'remember_token' => Str::random(80),
            'company_id' => 1,
        ]);

        $user->assignRole('owner');
        Company::create([
            'name' => $request->name,
            'subdomain' => strtolower(str_replace(' ', '', $request->name)),
            'logo' => '',
            'cover' => '',
            'active' => 1,
            'minimum' => '0',
            'description' => '',
            'fee' => 0.000,
            'static_fee' => 0.000,
            'is_featured' => 0,
            'views' => 0,
            'whatsapp_phone' => '',
            'do_covertion' => 1,
            'user_id' => $user->id,
        ]);
        $user->save();
        // Redireccionar o devolver una respuesta
        return redirect('/companies')->with('status', 'Usuario creado correctamentea!');
    }
}
