<?php
namespace App\Exports;

use Modules\Solicitudes\Models\Solicitud;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class SolicitudesExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    private $solicitudes;

    public function __construct()
    {
        // Carga de datos
        $this->solicitudes = Solicitud::get()->map(function ($solicitud) {
            // Concatenar "S" al ID
            $solicitud->id = 'S' . $solicitud->id;

            // Convertir estatus opcional a texto
            $estatus = [
                1 => 'Creado',
                2 => 'Capturado',
                3 => 'En ejecución',
                4 => 'Terminado',
                5 => 'Crítico',
            ];
            $solicitud->estatusOpciones = $estatus[$solicitud->estatusOpciones] ?? 'Desconocido';

            return $solicitud;
        });
    }

    public function collection()
    {
        return $this->solicitudes;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Tipo de Solicitud',
            'Celular',
            'Nombre o Servicio',
            'Nombre de Persona',
            'Ubicación',
            'Referencia',
            'Estatus',
            'Fecha de Creación',
        ];
    }

    public function map($solicitud): array
    {
        return [
            $solicitud->id,
            $solicitud->tipo_solicitud,
            $solicitud->celular,
            $solicitud->nombre_o_servicio,
            $solicitud->nombre_persona,
            $solicitud->ubicacion,
            $solicitud->referencia,
            $solicitud->estatusOpciones,
            $solicitud->created_at->format('d/m/Y'),
        ];
    }
}
