<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;

class SendScheduledMessages extends Command
{
    protected $signature = 'send:scheduled-messages';
    protected $description = 'Send scheduled messages by making a GET request to the specified URL';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $response = Http::get(env('APP_URL')."/webhook/wpbox/sendschuduledmessages");

        if ($response->successful()) {
            $this->info('Scheduled messages sent successfully.');
        } else {
            $this->error('Failed to send scheduled messages.');
        }

        return 0;
    }
}
